/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.internal.parser;

import com.ibm.debug.xmlui.Activator;
import com.ibm.debug.xmlui.api.XUIParseException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XUIAbstractParser {
    protected Document getDocument(InputStream stream) throws XUIParseException {
        Document dom = null;
        try {
            DocumentBuilderFactory factory = this.getSecureDocumentBuilderFactory();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            dom = builder.parse(stream);
        }
        catch (ParserConfigurationException pce) {
            throw new XUIParseException(pce);
        }
        catch (Exception e) {
            throw new XUIParseException(e);
        }
        return dom;
    }

    protected boolean nodeNameEquals(Node node, String namespace, String localName) {
        return this.stringEquals(node.getLocalName(), localName) && this.stringEquals(node.getNamespaceURI(), namespace);
    }

    protected boolean nodeNameEquals(Node node, String localName) {
        return this.stringEquals(node.getLocalName(), localName);
    }

    private boolean stringEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }

    private DocumentBuilderFactory getSecureDocumentBuilderFactory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (Exception e) {
            Activator.getLogFile().log((IStatus)new Status(4, "com.ibm.debug.xmlui", e.getMessage(), (Throwable)e));
            return null;
        }
    }
}

