/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.internal.parser;

import com.ibm.debug.xmlui.api.IXUIContainer;
import com.ibm.debug.xmlui.api.IXUIElement;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.api.XUIModel;
import com.ibm.debug.xmlui.internal.parser.XUIRadioButton;
import com.ibm.debug.xmlui.internal.parser.XUIRadioGroup;
import java.util.ArrayList;

public abstract class XUIAbstractElement
implements IXUIElement {
    protected static final XUIAttributeList EMPTY_ATTRIBUTES = new XUIAttributeList();
    private String fId;
    private String fNameKey;
    private String fName;
    private IXUIElement fParent;
    private boolean fIsSelected;
    private Object fData;
    private ArrayList<IXUIElement> fChildElements = new ArrayList();

    public XUIAbstractElement(IXUIElement parent) {
        this.fParent = parent;
    }

    public XUIAbstractElement(String id, String name, IXUIElement parent) {
        this.fId = id;
        this.fName = name;
        this.fParent = parent;
    }

    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IXUIElement getParent() {
        return this.fParent;
    }

    public void setNamekey(String nameKey) {
        this.fNameKey = nameKey;
    }

    @Override
    public String getNameKey() {
        return this.fNameKey;
    }

    @Override
    public void addChildElement(IXUIElement element) {
        this.fChildElements.add(element);
    }

    @Override
    public ArrayList<IXUIElement> getChildElements() {
        return this.fChildElements;
    }

    @Override
    public int getChildCount() {
        return this.fChildElements.size();
    }

    @Override
    public void setData(Object data) {
        this.fData = data;
    }

    @Override
    public Object getData() {
        return this.fData;
    }

    @Override
    public boolean isSelected() {
        return this.fIsSelected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.fIsSelected = selected;
    }

    @Override
    public XUIModel getModel() {
        IXUIElement ancestor = this.getParent();
        while (!(ancestor instanceof XUIModel) && ancestor != null) {
            ancestor = ancestor.getParent();
        }
        return (XUIModel)ancestor;
    }

    @Override
    public XUIAttributeList getAttributes() {
        if (this instanceof IXUIContainer) {
            return this.getChildrenAttributes();
        }
        return EMPTY_ATTRIBUTES;
    }

    protected XUIRadioButton findSelectedRadioButton(XUIRadioGroup radioGroup) {
        ArrayList<IXUIElement> children = radioGroup.getChildElements();
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            if (child instanceof XUIRadioButton && child.isSelected()) {
                return (XUIRadioButton)child;
            }
            ++i;
        }
        return null;
    }

    protected XUIAttributeList getChildrenAttributes() {
        XUIAttributeList attributes = new XUIAttributeList();
        int i = 0;
        while (i < this.fChildElements.size()) {
            XUIAttributeList childAttributes;
            IXUIElement child = this.fChildElements.get(i);
            if (child != null && (childAttributes = child.getAttributes()).size() > 0) {
                attributes.addAttributeList(childAttributes);
            }
            ++i;
        }
        return attributes;
    }
}

