/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.hover;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.hover.PDTInformationControlCreator;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDTTextHover2
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    protected ITextEditor fEditor;
    private ViewFile fViewFile;
    private boolean fIsIndicator = false;

    public PDTTextHover2(ITextEditor editor) {
        this.fEditor = editor;
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        ViewFile vf;
        PDTDebugTarget dt = null;
        if (this.fEditor != null && (vf = PICLUtils.getViewFile(this.fEditor.getEditorInput())) != null) {
            if (vf.getDebugTarget() instanceof PDTDebugTarget) {
                ExpressionBase expr;
                dt = (PDTDebugTarget)vf.getDebugTarget();
                if (dt != null && (expr = dt.getHoverExpression()) != null) {
                    dt.setHoverExpression(null);
                    try {
                        expr.remove();
                    }
                    catch (EngineRequestException engineRequestException) {}
                }
            } else {
                return null;
            }
        }
        if (!PreferenceUI.isAllowHover()) {
            return null;
        }
        if (this.fEditor == null) {
            return null;
        }
        IRegion hoverRegion = this.getHoverRegionImpl(textViewer, offset);
        if (hoverRegion == null) {
            return null;
        }
        this.getHoverInfo2Impl(textViewer, hoverRegion);
        if (dt != null && dt.getHoverExpression() != null) {
            return hoverRegion;
        }
        return null;
    }

    public IRegion getHoverRegionImpl(ITextViewer textViewer, int offset) {
        IEditorInput ie = this.fEditor.getEditorInput();
        short viewInfoID = 2;
        if (ie instanceof EngineSuppliedViewEditorInput) {
            EngineSuppliedViewEditorInput eei = (EngineSuppliedViewEditorInput)ie;
            viewInfoID = eei.getViewInformation().getKind();
        }
        this.fViewFile = PICLUtils.getViewFile(ie);
        if (this.fViewFile == null || this.fViewFile.haveDoneCleanup()) {
            return null;
        }
        IRegion region = this.getSelection(textViewer.getSelectionProvider().getSelection(), offset);
        if (region == null) {
            IdentifierParser parser;
            String line;
            IRegion lineRegion;
            IDocument doc = textViewer.getDocument();
            try {
                lineRegion = doc.getLineInformationOfOffset(offset);
                line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
            }
            catch (BadLocationException e) {
                return null;
            }
            try {
                parser = this.fViewFile.getView().getPart().getLanguage().getIdentifierParser();
            }
            catch (NullPointerException npe) {
                return null;
            }
            parser.setViewInfoID(viewInfoID);
            int lineNumber = -1;
            try {
                lineNumber = doc.getLineOfOffset(offset) + 1;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int[] posns = parser.identifierInString(this.fViewFile, lineNumber, line, offset - lineRegion.getOffset());
            this.fIsIndicator = parser.isIndicator();
            if (posns == null || posns[0] < 0) {
                return null;
            }
            region = new Region(lineRegion.getOffset() + posns[0], posns[1] - posns[0] + 1);
        }
        return region;
    }

    private IRegion getSelection(ISelection sel, int offset) {
        if (sel instanceof TextSelection) {
            TextSelection textSel = (TextSelection)sel;
            if (textSel.isEmpty() || textSel.getLength() == 0) {
                return null;
            }
            if (offset >= textSel.getOffset() && offset < textSel.getOffset() + textSel.getLength()) {
                return new Region(textSel.getOffset(), textSel.getLength());
            }
            return null;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new PDTInformationControlCreator(this.fEditor);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.fEditor == null) {
            return null;
        }
        if (!PreferenceUI.isAllowHover()) {
            return null;
        }
        IEditorInput ie = this.fEditor.getEditorInput();
        this.fViewFile = PICLUtils.getViewFile(ie);
        if (this.fViewFile == null || this.fViewFile.haveDoneCleanup()) {
            return null;
        }
        PDTDebugTarget tgt = (PDTDebugTarget)this.fViewFile.getDebugTarget();
        return tgt == null ? null : tgt.getHoverExpression();
    }

    public void getHoverInfo2Impl(ITextViewer textViewer, IRegion hoverRegion) {
        Location loc;
        IDebugTarget dt = this.fViewFile.getDebugTarget();
        if (!(dt instanceof PDTDebugTarget)) {
            return;
        }
        String expression = null;
        try {
            IDocument doc = textViewer.getDocument();
            expression = doc.get(hoverRegion.getOffset(), hoverRegion.getLength());
            IdentifierParser parser = this.fViewFile.getView().getPart().getLanguage().getIdentifierParser();
            expression = parser.updateExpression(expression, this.fIsIndicator);
            if (expression.length() > 1024) {
                return;
            }
            IEditorInput ei = this.fEditor.getEditorInput();
            int lineNum = doc.getLineOfOffset(hoverRegion.getOffset());
            if (ei instanceof EngineSuppliedViewEditorInput) {
                lineNum = PICLUtils.getRealLineNumber(ei, lineNum + 1);
            }
            loc = new Location(this.fViewFile, lineNum);
        }
        catch (BadLocationException e) {
            return;
        }
        PDTDebugTarget dbgtgt = (PDTDebugTarget)dt;
        if (dbgtgt.isSuspended() && !dbgtgt.getDebugEngine().isProgramTerminating()) {
            DebuggeeThread thread = PICLDebugPlugin.getCurrentThread();
            if (thread == null || thread.getDebugTarget() != dbgtgt) {
                thread = dbgtgt.getStoppingThread();
            }
            if (thread != null) {
                try {
                    dbgtgt.setHoverExpression(thread.evaluateExpression(loc, expression, 1, 0, false));
                }
                catch (EngineRequestException engineRequestException) {
                    // empty catch block
                }
            }
        }
    }
}

