/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDTTextHover
implements ITextHover {
    protected ITextEditor fEditor = null;
    protected String fHoverText = null;

    public PDTTextHover(ITextEditor editor) {
        this.fEditor = editor;
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.fHoverText = null;
        if (this.fEditor == null || !(this.fEditor instanceof LpexAbstractTextEditor)) {
            return null;
        }
        if (!PreferenceUI.isAllowHover()) {
            return null;
        }
        this.fHoverText = this.getHoverText(textViewer, hoverRegion);
        return this.fHoverText;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.fEditor == null || !(this.fEditor instanceof LpexAbstractTextEditor)) {
            return null;
        }
        if (!PreferenceUI.isAllowHover()) {
            return null;
        }
        PDTDebugTarget tgt = PICLDebugPlugin.getCurrentPDTDebugTarget();
        if (tgt == null || PICLUtils.getViewFile(this.fEditor.getEditorInput()) == null) {
            return null;
        }
        return new Region(offset, 1);
    }

    protected String getHoverText(ITextViewer textViewer, IRegion hoverRegion) {
        ISelection textSelection;
        ViewFile viewFile = PICLDebugPlugin.getViewFile(this.fEditor);
        IEditorInput ei = this.fEditor.getEditorInput();
        String expression = null;
        int lineNum = 0;
        LpexView lpexView = ((LpexAbstractTextEditor)this.fEditor).getLpexView();
        LpexDocumentLocation loc = this.documentLocationAtOffset(textViewer, hoverRegion.getOffset());
        String fullLineText = lpexView.elementText(loc.element);
        lineNum = loc.element;
        lineNum = lpexView.lineOfElement(loc.element);
        int prefixLength = 0;
        short viewInfoID = 2;
        if (ei instanceof EngineSuppliedViewEditorInput) {
            EngineSuppliedViewEditorInput eei = (EngineSuppliedViewEditorInput)ei;
            prefixLength = eei.getPrefixLength();
            if (loc.position - 1 <= prefixLength) {
                return null;
            }
            viewInfoID = eei.getViewInformation().getKind();
        }
        if ((textSelection = textViewer.getSelectionProvider().getSelection()) instanceof ITextSelection && ((ITextSelection)textSelection).getText() != null && !((ITextSelection)textSelection).getText().equals("")) {
            int textSelectionStartOffset = ((ITextSelection)textSelection).getOffset();
            int textSelectionEndOffset = ((ITextSelection)textSelection).getOffset() + ((ITextSelection)textSelection).getLength();
            if (hoverRegion.getOffset() >= textSelectionStartOffset && hoverRegion.getOffset() <= textSelectionEndOffset) {
                expression = ((ITextSelection)textSelection).getText();
            }
        }
        IdentifierParser parser = null;
        try {
            parser = viewFile.getPart().getLanguage().getIdentifierParser();
        }
        catch (NullPointerException textSelectionEndOffset) {
            // empty catch block
        }
        if (parser != null) {
            parser.setPrefixLength(prefixLength);
            parser.setViewInfoID(viewInfoID);
            if (expression == null || expression.equals("")) {
                int[] identifierInString = parser.identifierInString(fullLineText, loc.position - 1);
                if (identifierInString == null || identifierInString[0] < 0) {
                    return null;
                }
                expression = fullLineText.substring(identifierInString[0], identifierInString[1] + 1);
            }
            expression = parser.doLanguageSpecifics(expression, fullLineText, loc.position + 1);
        }
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        lineNum = PICLUtils.getRealLineNumber(ei, lineNum);
        Location location = new Location(viewFile, lineNum);
        DebuggeeThread thread = PICLDebugPlugin.getCurrentThread();
        if (thread == null) {
            return null;
        }
        IDebugTarget dbgtgt = thread.getDebugTarget();
        if (dbgtgt.isSuspended()) {
            ExpressionBase evalExpression = null;
            try {
                evalExpression = thread.evaluateExpression(location, expression, 1, 0, true);
            }
            catch (EngineRequestException e1) {
                return null;
            }
            if (evalExpression == null) {
                return null;
            }
            ExprNodeBase treeNode = evalExpression.getRootNode();
            if (treeNode == null) {
                return null;
            }
            String nodeName = treeNode.getName();
            String nodeValue = treeNode.getValueString();
            String nodeType = null;
            try {
                if (PreferenceUI.isDisplayHoverTypes()) {
                    nodeType = treeNode.getReferenceTypeName();
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            StringBuilder label = new StringBuilder();
            if (nodeType != null) {
                label.append(nodeType);
                label.append(' ');
            }
            label.append(nodeName);
            if (nodeValue != null) {
                label.append(" = ").append(nodeValue);
            }
            return label.toString();
        }
        return null;
    }

    private LpexDocumentLocation documentLocationAtOffset(ITextViewer textViewer, int offset) {
        return ((LpexTextViewer)textViewer).getLpexDocumentLocation(offset);
    }
}

