/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.AddEditorWatchBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.AddSnippetToMonitorAction;
import com.ibm.debug.pdt.internal.ui.actions.ChangeTextFileAction;
import com.ibm.debug.pdt.internal.ui.actions.EditorBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.EditorEditBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.EditorSourceLookupAction;
import com.ibm.debug.pdt.internal.ui.actions.FindFunctionAction;
import com.ibm.debug.pdt.internal.ui.actions.FindNextAction;
import com.ibm.debug.pdt.internal.ui.actions.FindTextAction;
import com.ibm.debug.pdt.internal.ui.actions.RunJumpToLocationBaseAction;
import com.ibm.debug.pdt.internal.ui.actions.SwitchDefaultViewAction;
import com.ibm.debug.pdt.internal.ui.actions.SwitchViewAction;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import com.ibm.debug.pdt.internal.ui.memory.MonitorMemoryMenuManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class DebugEditorActionContributor {
    private ITextEditor fTextEditor;
    private IVerticalRuler fVerticalRuler;
    public static final int BREAKPOINT_RULER_ACTION = 1;
    public static final int JUMP_RULER_ACTION = 2;
    public static final int RUN_RULER_ACTION = 4;
    public static final int ENABLE_BREAKPOINT_RULER_ACTION = 8;
    public static final int ENGINE_BREAKPOINT_RULER_ACTION = 16;
    public static final int EDIT_BREAKPOINT_RULER_ACTION = 64;
    public static final int ALL_RULER_ACTIONS = 95;
    public static final int BREAKPOINT_MENU_ACTION = 1;
    public static final int JUMP_MENU_ACTION = 2;
    public static final int RUN_MENU_ACTION = 4;
    public static final int MONITOR_MENU_ACTION = 8;
    public static final int STORAGE_MENU_ACTION = 16;
    public static final int ENABLE_BREAKPOINT_MENU_ACTION = 64;
    public static final int CHANGE_TEXT_FILE_MENU_ACTION = 128;
    public static final int SWITCH_VIEW_MENU_ACTION = 256;
    public static final int WATCH_BREAKPOINT_MENU_ACTION = 1024;
    public static final int ENGINE_BREAKPOINT_MENU_ACTION = 2048;
    public static final int EDIT_BREAKPOINT_MENU_ACTION = 8192;
    public static final int FIND_TEXT_MENU_ACTION = 16384;
    public static final int FIND_NEXT_MENU_ACTION = 32768;
    public static final int FIND_FUNCTION_MENU_ACTION = 65536;
    public static final int MAP_STORAGE_MENU_ACTION = 131072;
    public static final int MANAGE_DEBUG_FILE_CONTEXTS_MENU_ACTION = 262144;
    public static final int EDIT_SOURCE_LOOKUP_MENU_ACTION = 524288;
    public static final int ALL_MENU_ACTIONS = 1043935;
    @Deprecated
    public static final int USE_WORKSPACE_ROOT_RESOURCE = 32;
    public static final String BREAKPOINT_RULER_ACTION_ID = "BreakpointRulerAction";
    public static final String EDIT_BREAKPOINT_RULER_ACTION_ID = "EditBreakpointRulerAction";
    public static final String ENABLE_BREAKPOINT_RULER_ACTION_ID = "EnableBreakpointRulerAction";
    public static final String JUMP_RULER_ACTION_ID = "JumpToLocationRulerAction";
    public static final String RUN_RULER_ACTION_ID = "RunToLocationRulerAction";
    public static final String ENGINE_BREAKPOINT_RULER_ACTION_ID = "EngineBreakpointRulerAction";
    public static final String BREAKPOINT_MENU_ACTION_ID = "BreakpointMenuAction";
    public static final String EDIT_BREAKPOINT_MENU_ACTION_ID = "EditBreakpointMenuAction";
    public static final String ENABLE_BREAKPOINT_MENU_ACTION_ID = "EnableBreakpointMenuAction";
    public static final String JUMP_MENU_ACTION_ID = "JumpToLocationMenuAction";
    public static final String RUN_MENU_ACTION_ID = "RunToLocationMenuAction";
    public static final String MONITOR_MENU_ACTION_ID = "AddSnippetToMonitorMenuAction";
    public static final String STORAGE_MENU_ACTION_ID = "AddSnippetToStorageMenuAction";
    public static final String MAP_STORAGE_MENU_ACTION_ID = "MapStorageMenuAction";
    public static final String EDIT_SOURCE_LOOKUP_MENU_ACTION_ID = "EditSourceLookupMenuAction";
    public static final String CHANGE_TEXT_FILE_MENU_ACTION_ID = "ChangeTextFileMenuAction";
    public static final String SWITCH_VIEW_MENU_ACTION_ID = "SwitchViewMenuAction";
    public static final String WATCH_BREAKPOINT_MENU_ACTION_ID = "AddWatchBreakpointMenuAction";
    public static final String ENGINE_BREAKPOINT_MENU_ACTION_ID = "EngineBreakpointMenuAction";
    public static final String FIND_TEXT_MENU_ACTION_ID = "FindTextMenuAction";
    public static final String FIND_NEXT_MENU_ACTION_ID = "FindNextMenuAction";
    public static final String FIND_FUNCTION_MENU_ACTION_ID = "FindFunctionMenuAction";
    public static final String MANAGE_DEBUG_FILE_CONTEXTS_MENU_ACTION_ID = "ManageDebugFileContextsMenuAction";
    public static final String DEBUG_BREAKPOINT_GROUP = "debug.breakpoint";
    public static final String DEBUG_RUNJUMP_GROUP = "debug.runjump";
    public static final String DEBUG_MONITOR_GROUP = "debug.monitor";
    public static final String DEBUG_FILEVIEW_GROUP = "debug.fileview";
    public static final String DEBUG_FIND_GROUP = "debug.find";
    private EditorBreakpointAction fAddBreakpointRulerAction = null;
    private EditorBreakpointAction fEnableBreakpointRulerAction = null;
    private EditorEditBreakpointAction fEditBreakpointRulerAction = null;
    private RunJumpToLocationBaseAction fJumpToLocationRulerAction = null;
    private RunJumpToLocationBaseAction fRunToLocationRulerAction = null;
    private EditorBreakpointAction fAddBreakpointMenuAction = null;
    private EditorBreakpointAction fEnableBreakpointMenuAction = null;
    private AddEditorWatchBreakpointAction fAddWatchBreakpointMenuAction = null;
    private EditorEditBreakpointAction fEditBreakpointMenuAction = null;
    private RunJumpToLocationBaseAction fJumpToLocationMenuAction = null;
    private RunJumpToLocationBaseAction fRunToLocationMenuAction = null;
    private AddSnippetToMonitorAction fAddSnippetToMonitorMenuAction = null;
    private EditorSourceLookupAction fEditorSourceLookupMenuAction = null;
    private ChangeTextFileAction fChangeTextFileMenuAction = null;
    private FindTextAction fFindTextMenuAction = null;
    private FindNextAction fFindNextMenuAction = null;
    private FindFunctionAction fFindFunctionMenuAction = null;

    public void createDebugRulerActions(ITextEditor editor, IVerticalRuler ruler) {
        this.fTextEditor = editor;
        this.fVerticalRuler = ruler;
        this.fAddBreakpointRulerAction = new EditorBreakpointAction(editor, (IVerticalRulerInfo)ruler, "", true, false);
        editor.setAction(BREAKPOINT_RULER_ACTION_ID, (IAction)this.fAddBreakpointRulerAction);
        this.fEnableBreakpointRulerAction = new EditorBreakpointAction(editor, (IVerticalRulerInfo)ruler, "", true, true);
        editor.setAction(ENABLE_BREAKPOINT_RULER_ACTION_ID, (IAction)this.fEnableBreakpointRulerAction);
        this.fEditBreakpointRulerAction = new EditorEditBreakpointAction(editor, (IVerticalRulerInfo)ruler, "", true);
        editor.setAction(EDIT_BREAKPOINT_RULER_ACTION_ID, (IAction)this.fEditBreakpointRulerAction);
        this.fJumpToLocationRulerAction = new RunJumpToLocationBaseAction(editor, (IVerticalRulerInfo)ruler, true, true);
        editor.setAction(JUMP_RULER_ACTION_ID, (IAction)this.fJumpToLocationRulerAction);
        this.fRunToLocationRulerAction = new RunJumpToLocationBaseAction(editor, (IVerticalRulerInfo)ruler, true, false);
        editor.setAction(RUN_RULER_ACTION_ID, (IAction)this.fRunToLocationRulerAction);
    }

    public void createDebugMenuActions(ITextEditor editor) {
        this.fTextEditor = editor;
        this.fAddBreakpointMenuAction = new EditorBreakpointAction(editor, null, "", false, false);
        editor.setAction(BREAKPOINT_MENU_ACTION_ID, (IAction)this.fAddBreakpointMenuAction);
        this.fEnableBreakpointMenuAction = new EditorBreakpointAction(editor, null, "", false, true);
        editor.setAction(ENABLE_BREAKPOINT_MENU_ACTION_ID, (IAction)this.fEnableBreakpointMenuAction);
        this.fAddWatchBreakpointMenuAction = new AddEditorWatchBreakpointAction();
        editor.setAction(WATCH_BREAKPOINT_MENU_ACTION_ID, (IAction)this.fAddWatchBreakpointMenuAction);
        this.fEditBreakpointMenuAction = new EditorEditBreakpointAction(editor, null, "", false);
        editor.setAction(EDIT_BREAKPOINT_MENU_ACTION_ID, (IAction)this.fEditBreakpointMenuAction);
        this.fJumpToLocationMenuAction = new RunJumpToLocationBaseAction(editor, null, false, true);
        editor.setAction(JUMP_MENU_ACTION_ID, (IAction)this.fJumpToLocationMenuAction);
        this.fRunToLocationMenuAction = new RunJumpToLocationBaseAction(editor, null, false, false);
        editor.setAction(RUN_MENU_ACTION_ID, (IAction)this.fRunToLocationMenuAction);
        this.fAddSnippetToMonitorMenuAction = new AddSnippetToMonitorAction(editor);
        editor.setAction(MONITOR_MENU_ACTION_ID, (IAction)this.fAddSnippetToMonitorMenuAction);
        this.fEditorSourceLookupMenuAction = new EditorSourceLookupAction(editor);
        editor.setAction(EDIT_SOURCE_LOOKUP_MENU_ACTION_ID, (IAction)this.fEditorSourceLookupMenuAction);
        this.fChangeTextFileMenuAction = new ChangeTextFileAction(null, editor);
        editor.setAction(CHANGE_TEXT_FILE_MENU_ACTION_ID, (IAction)this.fChangeTextFileMenuAction);
        if (editor instanceof DebuggerEditor) {
            this.fFindTextMenuAction = new FindTextAction((DebuggerEditor)editor);
            editor.setAction(FIND_TEXT_MENU_ACTION_ID, (IAction)this.fFindTextMenuAction);
            this.fFindNextMenuAction = new FindNextAction((DebuggerEditor)editor);
            editor.setAction(FIND_NEXT_MENU_ACTION_ID, (IAction)this.fFindNextMenuAction);
            this.fFindFunctionMenuAction = new FindFunctionAction((DebuggerEditor)editor);
            editor.setAction(FIND_FUNCTION_MENU_ACTION_ID, (IAction)this.fFindFunctionMenuAction);
        }
    }

    public void addDebugEditorRulerActions(IMenuManager menu, int flags) {
        this.addDebugEditorRulerActions(menu, flags, null);
    }

    public void addDebugEditorRulerActions(IMenuManager menu, int flags, String groupName) {
        int lineNumber = this.getLineNumber(true);
        boolean executableLine = this.isLineExecutable(lineNumber + 1);
        this.addDebugEditorRulerActions(menu, flags, executableLine, groupName);
    }

    private void addDebugEditorRulerActions(IMenuManager menu, int flags, boolean executable, String groupName) {
        boolean hasViewFileContext;
        PICLDebugTarget piclDbgTgt = this.getDebugTarget();
        if (piclDbgTgt != null && piclDbgTgt.isTerminated()) {
            piclDbgTgt = null;
        }
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (groupName == null) {
            menu.add((IContributionItem)new GroupMarker(DEBUG_BREAKPOINT_GROUP));
        } else {
            menu.appendToGroup(groupName, (IContributionItem)new GroupMarker(DEBUG_BREAKPOINT_GROUP));
        }
        menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IContributionItem)new GroupMarker(DEBUG_RUNJUMP_GROUP));
        if ((flags & 0x40) != 0 && this.fEditBreakpointRulerAction.showAction()) {
            this.fEditBreakpointRulerAction.update();
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fEditBreakpointRulerAction);
        }
        if ((flags & 1) != 0) {
            this.fAddBreakpointRulerAction.update();
            this.fAddBreakpointRulerAction.setEnabled(executable);
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fAddBreakpointRulerAction);
        }
        if ((flags & 8) != 0 && (piclDbgTgt == null || piclDbgTgt.supportsEnableDisableBreakpoints()) && this.fEnableBreakpointRulerAction.showAction()) {
            this.fEnableBreakpointRulerAction.update();
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fEnableBreakpointRulerAction);
        }
        if (piclDbgTgt == null) {
            return;
        }
        boolean isBusy = !piclDbgTgt.isAcceptingRequests();
        boolean bl = hasViewFileContext = PICLUtils.getViewFile(editorInput) != null;
        if ((flags & 2) != 0 && (flags & 4) != 0) {
            menu.insertBefore(DEBUG_RUNJUMP_GROUP, (IContributionItem)new Separator(DEBUG_RUNJUMP_GROUP));
        }
        if ((flags & 2) != 0 && piclDbgTgt.supportsJumpToLocation()) {
            this.fJumpToLocationRulerAction.setEnabled(executable && !isBusy && hasViewFileContext);
            this.fJumpToLocationRulerAction.update();
            menu.appendToGroup(DEBUG_RUNJUMP_GROUP, (IAction)this.fJumpToLocationRulerAction);
        }
        if ((flags & 4) != 0 && piclDbgTgt.supportsRunToLocation()) {
            this.fRunToLocationRulerAction.setEnabled(executable && !isBusy && hasViewFileContext);
            this.fRunToLocationRulerAction.update();
            menu.appendToGroup(DEBUG_RUNJUMP_GROUP, (IAction)this.fRunToLocationRulerAction);
        }
    }

    public void addDebugEditorMenuActions(IMenuManager menu, int flags) {
        this.addDebugEditorMenuActions(menu, flags, null);
    }

    public void addDebugEditorMenuActions(IMenuManager menu, int flags, String groupName) {
        int lineNumber = this.getLineNumber(false);
        boolean executableLine = this.isLineExecutable(lineNumber);
        this.addDebugEditorMenuActions(menu, flags, executableLine, groupName);
    }

    private void addDebugEditorMenuActions(IMenuManager menu, int flags, boolean executable, String groupName) {
        boolean hasViewFileContext;
        boolean isBusy;
        PICLDebugTarget piclDbgTgt = this.getDebugTarget();
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        boolean bl = piclDbgTgt != null && !piclDbgTgt.isTerminated() ? !piclDbgTgt.isAcceptingRequests() : (isBusy = true);
        if (groupName == null) {
            menu.add((IContributionItem)new GroupMarker(DEBUG_FIND_GROUP));
        } else {
            menu.appendToGroup(groupName, (IContributionItem)new GroupMarker(DEBUG_FIND_GROUP));
        }
        menu.appendToGroup(DEBUG_FIND_GROUP, (IContributionItem)new GroupMarker(DEBUG_BREAKPOINT_GROUP));
        menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IContributionItem)new GroupMarker(DEBUG_RUNJUMP_GROUP));
        menu.appendToGroup(DEBUG_RUNJUMP_GROUP, (IContributionItem)new GroupMarker(DEBUG_MONITOR_GROUP));
        menu.appendToGroup(DEBUG_MONITOR_GROUP, (IContributionItem)new GroupMarker(DEBUG_FILEVIEW_GROUP));
        menu.insertBefore(DEBUG_BREAKPOINT_GROUP, (IContributionItem)new Separator(DEBUG_BREAKPOINT_GROUP));
        if (editorInput instanceof EngineSuppliedViewEditorInput) {
            if ((flags & 0x4000) != 0) {
                this.fFindTextMenuAction.setEnabled(!isBusy);
                menu.appendToGroup(DEBUG_FIND_GROUP, (IAction)this.fFindTextMenuAction);
            }
            if ((flags & 0x8000) != 0) {
                this.fFindNextMenuAction.setEnabled(!isBusy);
                this.fFindNextMenuAction.update();
                menu.appendToGroup(DEBUG_FIND_GROUP, (IAction)this.fFindNextMenuAction);
            }
            if ((flags & 0x10000) != 0) {
                this.fFindFunctionMenuAction.setEnabled(!isBusy);
                this.fFindFunctionMenuAction.update();
                menu.appendToGroup(DEBUG_FIND_GROUP, (IAction)this.fFindFunctionMenuAction);
            }
        }
        if ((flags & 0x2000) != 0 && this.fEditBreakpointMenuAction.showAction()) {
            this.fEditBreakpointMenuAction.update();
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fEditBreakpointMenuAction);
        }
        if ((flags & 1) != 0) {
            this.fAddBreakpointMenuAction.update();
            this.fAddBreakpointMenuAction.setEnabled(executable);
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fAddBreakpointMenuAction);
        }
        if ((flags & 0x40) != 0 && (piclDbgTgt == null || piclDbgTgt.supportsEnableDisableBreakpoints()) && this.fEnableBreakpointMenuAction.showAction()) {
            this.fEnableBreakpointMenuAction.update();
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fEnableBreakpointMenuAction);
        }
        if (piclDbgTgt == null || piclDbgTgt.isTerminated()) {
            return;
        }
        boolean bl2 = hasViewFileContext = PICLUtils.getViewFile(editorInput) != null;
        if ((flags & 0x400) != 0 && piclDbgTgt.supportsChangeAddrBreakpoints()) {
            this.fAddWatchBreakpointMenuAction.setEnabled(!isBusy);
            this.fAddWatchBreakpointMenuAction.update();
            menu.appendToGroup(DEBUG_BREAKPOINT_GROUP, (IAction)this.fAddWatchBreakpointMenuAction);
        }
        if ((flags & 2) != 0 || (flags & 4) != 0) {
            menu.insertBefore(DEBUG_RUNJUMP_GROUP, (IContributionItem)new Separator(DEBUG_RUNJUMP_GROUP));
        }
        if ((flags & 2) != 0 && piclDbgTgt.supportsJumpToLocation()) {
            this.fJumpToLocationMenuAction.setEnabled(executable && !isBusy && hasViewFileContext);
            this.fJumpToLocationMenuAction.update();
            menu.appendToGroup(DEBUG_RUNJUMP_GROUP, (IAction)this.fJumpToLocationMenuAction);
        }
        if ((flags & 4) != 0 && piclDbgTgt.supportsRunToLocation()) {
            this.fRunToLocationMenuAction.setEnabled(executable && !isBusy && hasViewFileContext);
            this.fRunToLocationMenuAction.update();
            menu.appendToGroup(DEBUG_RUNJUMP_GROUP, (IAction)this.fRunToLocationMenuAction);
        }
        if ((flags & 8) != 0 || (flags & 0x10) != 0) {
            menu.insertBefore(DEBUG_MONITOR_GROUP, (IContributionItem)new Separator(DEBUG_MONITOR_GROUP));
        }
        if ((flags & 8) != 0 && piclDbgTgt.supportsMonitoringExpressions()) {
            this.fAddSnippetToMonitorMenuAction.setEnabled(!isBusy);
            this.fAddSnippetToMonitorMenuAction.update();
            menu.appendToGroup(DEBUG_MONITOR_GROUP, (IAction)this.fAddSnippetToMonitorMenuAction);
        }
        if ((flags & 0x10) != 0 && piclDbgTgt.supportsStorageRetrieval()) {
            menu.appendToGroup(DEBUG_MONITOR_GROUP, (IContributionItem)new MonitorMemoryMenuManager(this.fTextEditor, piclDbgTgt));
        }
        if ((flags & 0x80000) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0) {
            menu.insertBefore(DEBUG_FILEVIEW_GROUP, (IContributionItem)new Separator(DEBUG_FILEVIEW_GROUP));
        }
        if ((flags & 0x80000) != 0 && editorInput instanceof EngineSuppliedViewEditorInput) {
            menu.appendToGroup(DEBUG_FILEVIEW_GROUP, (IAction)this.fEditorSourceLookupMenuAction);
        }
        if ((flags & 0x80) != 0 && editorInput instanceof EngineSuppliedViewEditorInput && ((EngineSuppliedViewEditorInput)editorInput).supportsFileSwitch()) {
            this.fChangeTextFileMenuAction.setEnabled(!isBusy);
            this.fChangeTextFileMenuAction.update();
            menu.appendToGroup(DEBUG_FILEVIEW_GROUP, (IAction)this.fChangeTextFileMenuAction);
        }
        if ((flags & 0x100) != 0) {
            ViewFile vf = null;
            vf = editorInput instanceof EngineSuppliedViewEditorInput ? ((EngineSuppliedViewEditorInput)editorInput).getViewFile() : PICLUtils.getViewFile(editorInput);
            if (vf != null) {
                MenuManager switchViewSubMenu = new MenuManager(PICLLabels.SwitchViewMenu_label);
                ViewInformation[] engineViews = piclDbgTgt.getDebugEngine().getSupportedViews();
                int i = 0;
                while (i < engineViews.length) {
                    if (engineViews[i] != null) {
                        switchViewSubMenu.add((IAction)new SwitchViewAction(engineViews[i], vf, this.fTextEditor, !isBusy));
                    }
                    ++i;
                }
                MenuManager switchViewDefaultSubMenu = null;
                if (piclDbgTgt.getDebugEngine().getEngineSession().isViewOrderSupported()) {
                    switchViewDefaultSubMenu = new MenuManager(PICLLabels.DebugEditorActionContributor_Set_Default_view);
                    int[] requestedViewOrder = piclDbgTgt.getDebugEngine().getRequestedViewOrder();
                    int i2 = 0;
                    while (i2 < engineViews.length) {
                        if (engineViews[i2] != null) {
                            int originalViewId = requestedViewOrder == null ? i2 : requestedViewOrder[i2 - 1];
                            switchViewDefaultSubMenu.add((IAction)new SwitchDefaultViewAction(engineViews[i2], vf, this.fTextEditor, !isBusy, piclDbgTgt.getDebugEngine(), originalViewId));
                        }
                        ++i2;
                    }
                }
                menu.appendToGroup(DEBUG_FILEVIEW_GROUP, (IContributionItem)switchViewSubMenu);
                if (switchViewDefaultSubMenu != null && switchViewDefaultSubMenu.getSize() > 1) {
                    switchViewSubMenu.add((IContributionItem)new Separator());
                    switchViewSubMenu.add((IContributionItem)switchViewDefaultSubMenu);
                }
            }
        }
    }

    private boolean isLineExecutable(int lineNumber) {
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        boolean executable = true;
        if (editorInput instanceof EngineSuppliedViewEditorInput) {
            int bufferedLineNumber = PICLUtils.getBufferedLineNumber(editorInput, lineNumber);
            return ((EngineSuppliedViewEditorInput)editorInput).isLineExecutable(bufferedLineNumber);
        }
        if (editorInput instanceof FileEditorInput) {
            ViewFile viewFile = PICLUtils.getViewFile(editorInput);
            if (viewFile != null) {
                return viewFile.isLineExecutable(lineNumber);
            }
            return true;
        }
        return executable;
    }

    private int getLineNumber(boolean getLineNumberFromRuler) {
        if (this.fVerticalRuler != null && getLineNumberFromRuler) {
            return PICLUtils.getRealLineNumber(this.fTextEditor.getEditorInput(), this.fVerticalRuler.getLineOfLastMouseButtonActivity());
        }
        return PICLUtils.getLineNumber((IEditorPart)this.fTextEditor);
    }

    private PICLDebugTarget getDebugTarget() {
        IEditorInput ei;
        PICLDebugTarget dbgtgt = null;
        if (this.fTextEditor != null && (ei = this.fTextEditor.getEditorInput()) instanceof EngineSuppliedViewEditorInput) {
            dbgtgt = ((EngineSuppliedViewEditorInput)ei).getPICLDebugTarget();
        }
        if (dbgtgt == null) {
            dbgtgt = PICLDebugPlugin.getCurrentPICLDebugTarget();
        }
        return dbgtgt;
    }
}

