/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMonitorParent;
import com.ibm.debug.pdt.internal.core.model.ExprNode;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.GlobalSymbol;
import com.ibm.debug.pdt.internal.epdc.EStdAction;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.CopyTreeViewToClipboardAction;
import com.ibm.debug.pdt.internal.ui.actions.DisableVariableMonitorAction;
import com.ibm.debug.pdt.internal.ui.actions.EditValueAction;
import com.ibm.debug.pdt.internal.ui.actions.GlobalListAction;
import com.ibm.debug.pdt.internal.ui.actions.GlobalSymbolsAction;
import com.ibm.debug.pdt.internal.ui.actions.MonitorExpressionAction;
import com.ibm.debug.pdt.internal.ui.actions.MonitorNodeExpressionAction;
import com.ibm.debug.pdt.internal.ui.actions.NodeAction;
import com.ibm.debug.pdt.internal.ui.actions.PreferenceDialogAction;
import com.ibm.debug.pdt.internal.ui.actions.PrintTreeViewAction;
import com.ibm.debug.pdt.internal.ui.actions.RemoveAllMonitorsAction;
import com.ibm.debug.pdt.internal.ui.actions.RemoveVariableFromMonitorAction;
import com.ibm.debug.pdt.internal.ui.actions.ShowDetailPaneAction;
import com.ibm.debug.pdt.internal.ui.actions.ShowTypeInfoAction;
import com.ibm.debug.pdt.internal.ui.actions.ToggleMemoryPaneAction;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.views.ISortableView;
import com.ibm.debug.pdt.internal.ui.views.MonitorContentProvider;
import com.ibm.debug.pdt.internal.ui.views.MonitorRenderingViewPane;
import com.ibm.debug.pdt.internal.ui.views.PDTVariableLabelProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewSynchronizationService;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite2;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MonitorView
extends AbstractDebugView
implements IDebugContextListener,
ISortableView,
ISelectionChangedListener,
IMemoryRenderingSite2 {
    protected static final String PREFIX = "MonitorView.";
    protected static final String RENDERING_PANE_ID = "com.ibm.debug.pdt.ui.MonitorView.RenderingViewPane.1";
    private static final boolean fSupportsMemoryView = Platform.getBundle((String)"com.ibm.debug.pdt.ui.memory.traditional") != null;
    private TreeViewer fTreeViewer = null;
    private Composite fTreeViewerComposite = null;
    private MonitorRenderingViewPane fMemoryPane = null;
    private DefaultDetailPane fDetailPane = null;
    private Control fDetailPaneControl = null;
    private boolean fShowAdditionalPane = PreferenceUI.getMonitorViewShowDetailPane();
    private boolean fMemoryMode = fSupportsMemoryView && PreferenceUI.getMonitorMemoryMode();
    private SashForm fSashForm;
    private Composite fAdditionalPane;
    private int[] fSashWeights = new int[]{PreferenceUI.getMonitorViewSashWeight1(), PreferenceUI.getMonitorViewSashWeight2()};
    private PDTDebugTarget fCurrentDebugTarget;
    private MemoryViewSynchronizationService fSyncService;
    private ViewForm fViewerViewForm;
    private IStructuredSelection fCurrentSelection;
    protected MonitorContentProvider fContentProvider = null;
    protected EditValueAction fEditVariableValueAction;
    protected MonitorNodeExpressionAction fMonitorNodeExpressionAction;
    protected MonitorExpressionAction fMonitorExpressionAction;
    protected ShowTypeInfoAction fShowTypeInfoAction;
    protected RemoveVariableFromMonitorAction fRemoveVariableFromMonitorAction;
    protected RemoveAllMonitorsAction fRemoveAllAction;
    protected DisableVariableMonitorAction fDisableVariableMonitorAction;
    protected CopyTreeViewToClipboardAction fCopyTreeViewToClipboardAction;
    protected PrintTreeViewAction fPrintTreeViewAction;
    protected ShowDetailPaneAction fShowAdditionalPaneAction;
    protected PreferenceDialogAction fPreferenceDialogAction;
    protected ToggleMemoryPaneAction fToggleMemoryPaneAction;
    private Composite fControl;

    protected Viewer createViewer(Composite parent) {
        this.fSashForm = new SashForm(parent, 66048);
        this.createTreeViewer((Composite)this.fSashForm);
        this.fAdditionalPane = new Composite((Composite)this.fSashForm, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.fAdditionalPane);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fAdditionalPane);
        this.createDetailPane(this.fAdditionalPane);
        this.fSashForm.setWeights(this.fSashWeights);
        this.setTitleToolTip(PICLLabels.MonitorView_tooltip);
        this.setInitialContent();
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        return this.fTreeViewer;
    }

    private void createTreeViewer(Composite parent) {
        this.fTreeViewerComposite = new Composite(parent, 0);
        this.fTreeViewerComposite.setLayout((Layout)new FillLayout());
        this.fTreeViewer = new TreeViewer(this.fTreeViewerComposite, 2);
        this.fContentProvider = new MonitorContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new PDTVariableLabelProvider());
        this.fTreeViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
    }

    private void createDetailPane(Composite parent) {
        this.fDetailPane = new DefaultDetailPane();
        this.fDetailPane.init(this.getSite());
        this.fDetailPaneControl = this.fDetailPane.createControl(parent);
    }

    private void createMemoryPane(Composite parent) {
        this.fMemoryPane = new MonitorRenderingViewPane((IViewPart)this);
        this.fViewerViewForm = new ViewForm(parent, 0);
        Control viewerControl = this.fMemoryPane.createViewPane((Composite)this.fViewerViewForm, RENDERING_PANE_ID, DebugUIMessages.MemoryView_Memory_monitors, false, false);
        this.fViewerViewForm.setContent(viewerControl);
        this.fSyncService = new MemoryViewSynchronizationService();
    }

    private void disposeMemoryPane() {
        if (this.fMemoryPane != null) {
            this.fMemoryPane.dispose();
        }
        if (this.fViewerViewForm != null) {
            this.fViewerViewForm.dispose();
        }
        if (this.fSyncService != null) {
            this.fSyncService.shutdown();
        }
        this.fMemoryPane = null;
        this.fViewerViewForm = null;
        this.fSyncService = null;
    }

    private void showAdditionalPane() {
        if (this.fMemoryMode) {
            if (this.fMemoryPane == null) {
                this.createMemoryPane(this.fAdditionalPane);
            }
            this.fSashForm.setMaximizedControl(null);
            this.showPage((Control)this.fViewerViewForm);
            this.fDetailPane.display(null);
            this.updateAdditionalPane();
            return;
        }
        if (this.fShowAdditionalPane) {
            this.fSashForm.setMaximizedControl(null);
            this.showPage(this.fDetailPaneControl);
            this.disposeMemoryPane();
            this.updateAdditionalPane();
        } else {
            this.fSashForm.setMaximizedControl((Control)this.fTreeViewerComposite);
            this.fDetailPane.display(null);
            this.disposeMemoryPane();
        }
    }

    private void showPage(Control control) {
        ViewForm toHide = control == this.fDetailPaneControl ? this.fViewerViewForm : this.fDetailPaneControl;
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        if (toHide != null) {
            GridDataFactory.swtDefaults().hint(0, 0).applyTo((Control)toHide);
        }
        this.fAdditionalPane.layout();
    }

    protected Control getDefaultControl() {
        return this.fSashForm;
    }

    protected void createActions() {
        this.fEditVariableValueAction = new EditValueAction((Viewer)this.fTreeViewer);
        this.fEditVariableValueAction.setEnabled(false);
        this.fMonitorNodeExpressionAction = new MonitorNodeExpressionAction((Viewer)this.fTreeViewer);
        this.fMonitorExpressionAction = new MonitorExpressionAction(false, this.getViewSite().getWorkbenchWindow());
        this.fMonitorExpressionAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_MONITOR_EXPRESSION"));
        this.fMonitorExpressionAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_MONITOR_EXPRESSION"));
        this.fMonitorExpressionAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_MONITOR_EXPRESSION"));
        this.fShowTypeInfoAction = new ShowTypeInfoAction((StructuredViewer)this.fTreeViewer);
        this.fShowTypeInfoAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_SHOW_TYPE_NAMES"));
        this.fShowTypeInfoAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_SHOW_TYPE_NAMES"));
        this.fShowTypeInfoAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_SHOW_TYPE_NAMES"));
        this.fShowTypeInfoAction.setChecked(false);
        this.fCopyTreeViewToClipboardAction = new CopyTreeViewToClipboardAction((StructuredViewer)this.fTreeViewer);
        this.fCopyTreeViewToClipboardAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_COPY_VIEW_TO_CLIPBOARD"));
        this.fCopyTreeViewToClipboardAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_COPY_VIEW_TO_CLIPBOARD"));
        this.fCopyTreeViewToClipboardAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.fCopyTreeViewToClipboardAction.setChecked(false);
        this.fPrintTreeViewAction = new PrintTreeViewAction((StructuredViewer)this.fTreeViewer, PICLLabels.MonitorView_printjobtitle);
        this.fPrintTreeViewAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_PRINT_VIEW"));
        this.fPrintTreeViewAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_PRINT_VIEW"));
        this.fPrintTreeViewAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_PRINT_VIEW"));
        this.fPrintTreeViewAction.setChecked(false);
        this.fRemoveVariableFromMonitorAction = new RemoveVariableFromMonitorAction((ISelectionProvider)this.fTreeViewer);
        this.fRemoveVariableFromMonitorAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_REMOVE_MONITOR"));
        this.fRemoveVariableFromMonitorAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_REMOVE_MONITOR"));
        this.fRemoveVariableFromMonitorAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_REMOVE_MONITOR"));
        this.fRemoveVariableFromMonitorAction.setChecked(false);
        this.fRemoveAllAction = new RemoveAllMonitorsAction((Viewer)this.fTreeViewer);
        this.fRemoveAllAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_REMOVE_ALL_MONITORS"));
        this.fRemoveAllAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_REMOVE_ALL_MONITORS"));
        this.fRemoveAllAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_REMOVE_ALL_MONITORS"));
        this.fDisableVariableMonitorAction = new DisableVariableMonitorAction((ISelectionProvider)this.fTreeViewer);
        this.fDisableVariableMonitorAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_DISABLE_MONITOR"));
        this.fDisableVariableMonitorAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_DISABLE_MONITOR"));
        this.fDisableVariableMonitorAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_DISABLE_MONITOR"));
        this.fDisableVariableMonitorAction.setChecked(false);
        this.fShowAdditionalPaneAction = new ShowDetailPaneAction(this);
        this.fShowAdditionalPaneAction.setChecked(!this.fShowAdditionalPane);
        this.fPreferenceDialogAction = new PreferenceDialogAction();
        if (fSupportsMemoryView) {
            this.fToggleMemoryPaneAction = new ToggleMemoryPaneAction(this);
            this.fToggleMemoryPaneAction.setChecked(this.fMemoryMode);
        }
    }

    public void setShowAdditionalPane(boolean show) {
        this.fShowAdditionalPane = show;
        this.showAdditionalPane();
    }

    public void setMemoryMode(boolean show) {
        this.fMemoryMode = show;
        this.showAdditionalPane();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IAction)this.fShowAdditionalPaneAction);
        viewMenu.add((IAction)this.fPreferenceDialogAction);
        tbm.add((IAction)this.fMonitorExpressionAction);
        tbm.add((IAction)this.fRemoveVariableFromMonitorAction);
        tbm.add((IAction)this.fRemoveAllAction);
        tbm.add((IAction)this.fDisableVariableMonitorAction);
        Separator invisibleSeparator = new Separator(this.getClass().getName());
        invisibleSeparator.setVisible(false);
        tbm.add((IContributionItem)invisibleSeparator);
        tbm.add((IContributionItem)new Separator(this.getClass().getName() + ".additions1"));
        tbm.add((IAction)this.fShowTypeInfoAction);
        if (fSupportsMemoryView) {
            tbm.add((IAction)this.fToggleMemoryPaneAction);
        }
        tbm.add((IContributionItem)new Separator(this.getClass().getName() + ".additions2"));
        tbm.add((IAction)this.fCopyTreeViewToClipboardAction);
        tbm.add((IAction)this.fPrintTreeViewAction);
    }

    protected String getHelpContextId() {
        return PICLUtils.getHelpResourceString("monitor_view");
    }

    protected void fillContextMenu(IMenuManager menu) {
        Object obj;
        ISelection selection = this.getViewSite().getWorkbenchWindow().getSelectionService().getSelection("com.ibm.debug.pdt.ui.MonitorView");
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        if (selection != null && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ExprNode) {
            EStdAction[] actions;
            ExprNode node = (ExprNode)obj;
            if (node.getEngineSession().supportsGetNodeExpression()) {
                menu.add((IAction)this.fMonitorNodeExpressionAction);
            }
            EStdAction[] eStdActionArray = actions = node.getActions();
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                EStdAction stdAction = eStdActionArray[n2];
                menu.add((IAction)new NodeAction(stdAction, node));
                ++n2;
            }
        }
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IAction)this.fEditVariableValueAction);
        menu.add((IAction)this.fMonitorExpressionAction);
        menu.add((IAction)this.fRemoveVariableFromMonitorAction);
        menu.add((IAction)this.fRemoveAllAction);
        menu.add((IAction)this.fDisableVariableMonitorAction);
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IAction)this.fShowTypeInfoAction);
        if (this.fCurrentDebugTarget != null) {
            if (this.fCurrentDebugTarget.supportsMonitorGlobalList()) {
                menu.add((IAction)new GlobalListAction(this.fCurrentDebugTarget));
            }
            if (this.fCurrentDebugTarget.supportsMonitorGlobalSymbols()) {
                GlobalSymbol[] symbols = null;
                if (this.fCurrentDebugTarget.getDebugEngine() != null) {
                    symbols = this.fCurrentDebugTarget.getDebugEngine().getGlobalSymbols();
                }
                if (symbols != null && symbols.length > 0) {
                    int i = 1;
                    while (i < symbols.length) {
                        menu.add((IAction)new GlobalSymbolsAction(symbols[i]));
                        ++i;
                    }
                }
            }
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void setInitialContent() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fControl, PICLUtils.getHelpResourceString("monitor_view"));
        this.setViewerInput(PICLDebugPlugin.getCurrentPDTDebugTarget());
        this.showAdditionalPane();
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() != 1) {
            return;
        }
        IDebugElement source = (IDebugElement)selection.getFirstElement();
        if (!(source instanceof ExprNodeBase)) {
            return;
        }
        if (((ExprNodeBase)source).hasChildren()) {
            if (this.fTreeViewer.getExpandedState((Object)source)) {
                this.fTreeViewer.collapseToLevel((Object)source, 1);
            } else {
                this.fTreeViewer.expandToLevel((Object)source, 1);
            }
        } else if (((ExprNodeBase)source).supportsValueModification()) {
            this.fEditVariableValueAction.run();
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.fRemoveVariableFromMonitorAction.isEnabled()) {
            this.fRemoveVariableFromMonitorAction.run();
        }
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.removePostSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.fDetailPane != null) {
            this.fDetailPane.dispose();
        }
        this.disposeMemoryPane();
        super.dispose();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.setViewerInput(PICLDebugPlugin.getPDTDebugTarget(event.getContext()));
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof MonitorView) {
            this.setInitialContent();
        }
    }

    protected void becomesVisible() {
        this.setInitialContent();
    }

    protected void becomesHidden() {
        if (!this.fSashForm.isDisposed()) {
            int[] sashWeights = this.fSashForm.getWeights();
            PreferenceUI.setMonitorViewShowDetailPane(this.fShowAdditionalPane);
            PreferenceUI.setMonitorMemoryMode(this.fMemoryMode);
            PreferenceUI.setMonitorViewSashWeight1(sashWeights[0]);
            PreferenceUI.setMonitorViewSashWeight2(sashWeights[1]);
            this.disposeMemoryPane();
        }
    }

    protected void setViewerInput(PDTDebugTarget selectedDebugTarget) {
        Object current;
        if (this.fCurrentDebugTarget == selectedDebugTarget) {
            return;
        }
        if (this.fCurrentDebugTarget != null && (current = this.fTreeViewer.getInput()) != null) {
            ((PICLMonitorParent)current).setExpandedElements(this.fTreeViewer.getExpandedElements());
        }
        this.fCurrentDebugTarget = selectedDebugTarget;
        if (this.fCurrentDebugTarget == null) {
            this.fTreeViewer.setInput(null);
        } else {
            PICLMonitorParent parent = this.fCurrentDebugTarget.getMonitorParent();
            if (parent != null) {
                this.fTreeViewer.setInput((Object)parent);
                this.fTreeViewer.setExpandedElements(parent.getExpandedElements());
            } else {
                this.fTreeViewer.setInput(null);
                this.fCurrentDebugTarget = null;
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fControl, PICLUtils.getHelpResourceString("monitor_view"));
    }

    public void createPartControl(Composite parent) {
        this.fControl = parent;
        super.createPartControl(parent);
    }

    @Override
    public void setSort(boolean sort) {
        this.fContentProvider.setSort(sort);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fCurrentSelection = (IStructuredSelection)event.getSelection();
        if (this.isVisible()) {
            this.updateAdditionalPane();
        }
    }

    private void updateAdditionalPane() {
        if (this.fMemoryMode) {
            this.fMemoryPane.display(this.fCurrentSelection);
        } else if (this.fShowAdditionalPane) {
            this.fDetailPane.display(this.fCurrentSelection);
        }
    }

    public IMemoryRenderingContainer getContainer(String arg0) {
        return this.fMemoryPane;
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        IMemoryRenderingContainer[] memContainer = new IMemoryRenderingContainer[]{this.fMemoryPane};
        return memContainer;
    }

    public IMemoryRenderingSynchronizationService getSynchronizationService() {
        return this.fSyncService;
    }

    public void setContainerVisible(String id, boolean visible) {
        this.fMemoryPane.setVisible(visible);
    }
}

