/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.memory.OrderedMemoryRenderingLister;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.ui.IViewPart;

public class MonitorRenderingViewPane
extends RenderingViewPane {
    private HashMap<PDTDebugElement, IMemoryRendering> fMonitorRenderingMap = new HashMap();
    private static final String HEX_CHAR_UNIFIED_RENDERING_ID = "com.ibm.debug.pdt.ui.memory.traditional.rendering.ibm";

    public MonitorRenderingViewPane(IViewPart parent) {
        super(parent);
    }

    public void addMemoryRendering(PDTDebugElement debugElement, IMemoryRenderingContainer container) throws CoreException {
        IMemoryRendering rendering;
        if (this.fMonitorRenderingMap.containsKey(debugElement)) {
            rendering = this.fMonitorRenderingMap.get(debugElement);
        } else {
            PICLMemoryBlock memblk = this.getMemoryBlock(debugElement);
            rendering = this.createHexCharUnifiedRendering((IMemoryBlock)memblk);
            if (rendering != null) {
                rendering.init(container, (IMemoryBlock)memblk);
                this.fMonitorRenderingMap.put(debugElement, rendering);
                super.addMemoryRendering(rendering);
            }
        }
        if (rendering != null) {
            this.handleMemoryBlockSelection(this.getTopMemoryTab(), rendering.getMemoryBlock());
        }
        ((CTabFolder)this.fStackLayout.topControl).setTabHeight(0);
    }

    private IMemoryRendering createHexCharUnifiedRendering(IMemoryBlock memBlk) throws CoreException {
        IMemoryRenderingType[] renderings;
        IMemoryRenderingType[] iMemoryRenderingTypeArray = renderings = OrderedMemoryRenderingLister.getList(memBlk);
        int n = renderings.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType rendering = iMemoryRenderingTypeArray[n2];
            if (rendering.getId().equals(HEX_CHAR_UNIFIED_RENDERING_ID)) {
                return rendering.createRendering();
            }
            ++n2;
        }
        return null;
    }

    private PICLMemoryBlock getMemoryBlock(PDTDebugElement element) throws DebugException {
        IMemoryBlockRetrieval retrieval;
        PDTDebugTarget tgt = PICLDebugPlugin.getPDTDebugTarget((IDebugElement)element);
        if (tgt != null && !tgt.isTerminated() && (retrieval = (IMemoryBlockRetrieval)tgt.getAdapter(IMemoryBlockRetrieval.class)) instanceof IMemoryBlockRetrievalExtension) {
            IMemoryBlockRetrievalExtension memSupport = (IMemoryBlockRetrievalExtension)retrieval;
            return (PICLMemoryBlock)memSupport.getExtendedMemoryBlock(null, (Object)element);
        }
        return null;
    }

    public void display(IStructuredSelection selection) {
        if (selection == null) {
            this.emptyFolder();
            return;
        }
        if (selection.isEmpty()) {
            this.fMonitorRenderingMap.clear();
            this.emptyFolder();
        }
        if (selection.getFirstElement() instanceof PDTDebugElement) {
            PDTDebugElement debugElement = (PDTDebugElement)selection.getFirstElement();
            try {
                this.addMemoryRendering(debugElement, (IMemoryRenderingContainer)this);
            }
            catch (CoreException e) {
                PDTCoreUtils.logString((Object)((Object)this), (String)"Request for memory failed. Ensure that variable has been initialized");
            }
        }
    }

    protected void emptyFolder() {
        if (!this.isDisposed()) {
            super.emptyFolder();
        }
    }
}

