/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.IPartitionCache;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTPendingElement;
import com.ibm.debug.pdt.internal.core.PICLMonitorParent;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExprNodeLocal;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionLocal;
import com.ibm.debug.pdt.internal.core.model.ExpressionLocal2;
import com.ibm.debug.pdt.internal.core.model.NodeValue;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.views.BasicDebugViewContentProvider;
import com.ibm.debug.pdt.internal.ui.views.PDTIndexedVariablePartition;
import java.util.Arrays;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.variables.IndexedValuePartition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MonitorContentProvider
extends BasicDebugViewContentProvider
implements IPropertyChangeListener {
    private boolean fSort;

    public MonitorContentProvider() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        PreferenceUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        try {
            PreferenceUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    protected void doHandleDebugEvent(DebugEvent event) {
        if (this.isDisposed()) {
            return;
        }
        Object obj = event.getSource();
        if (obj instanceof ExpressionLocal || obj instanceof ExpressionLocal2 || obj instanceof ExprNodeLocal) {
            return;
        }
        if (obj instanceof ExpressionBase) {
            this.refresh();
        } else if (obj instanceof ExprNodeBase || obj instanceof PDTIndexedVariablePartition) {
            switch (event.getKind()) {
                case 4: {
                    this.refresh(((PDTDebugElement)obj).getParentElement());
                    break;
                }
                case 16: {
                    this.refresh(obj);
                    break;
                }
            }
        } else if (obj instanceof DebuggeeThread) {
            if (event.getKind() == 2) {
                this.refresh();
            }
        } else if (obj instanceof DebuggeeProcess && event.getKind() == 8) {
            this.refresh();
        }
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.fViewer.setSelection(this.fViewer.getSelection());
    }

    @Override
    protected void refresh(Object element) {
        super.refresh(element);
        this.fViewer.setSelection(this.fViewer.getSelection());
    }

    protected void setSort(boolean sort) {
        this.fSort = sort;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        Object[] returnedElements = EMPTYOBJECTS;
        boolean sort = this.fSort;
        if (parentElement instanceof PICLMonitorParent) {
            try {
                returnedElements = ((PDTDebugElement)parentElement).getChildren();
            }
            catch (EngineRequestException e) {
                PICLUtils.logError((Exception)((Object)e));
                return EMPTYOBJECTS;
            }
        }
        if (parentElement instanceof IVariable) {
            IVariable variable = (IVariable)parentElement;
            IValue value = null;
            try {
                value = variable.getValue();
                if (!value.hasVariables()) {
                    return EMPTYOBJECTS;
                }
                if (value instanceof IIndexedValue) {
                    IIndexedValue indxValue = (IIndexedValue)value;
                    int partitionSize = this.computePartitionSize(indxValue);
                    if (partitionSize <= 1) {
                        if (indxValue instanceof NodeValue && ((NodeValue)indxValue).isVariablesRetrieved() || indxValue instanceof IndexedValuePartition && ((PDTIndexedVariablePartition)variable).isVariablesRetrieved()) {
                            returnedElements = indxValue.getVariables();
                        } else {
                            returnedElements = PENDING;
                            Object[] children = super.getChildren(variable);
                            if (!(children[0] instanceof PDTPendingElement)) {
                                returnedElements = children;
                            }
                        }
                    } else {
                        if (parentElement instanceof IPartitionCache) {
                            IPartitionCache partitionedVar = (IPartitionCache)parentElement;
                            if (partitionedVar.hasPartitionCache()) {
                                returnedElements = partitionedVar.getPartitionCache();
                            } else {
                                int numPartitions = indxValue.getSize() / partitionSize;
                                if (indxValue.getSize() % partitionSize > 0) {
                                    ++numPartitions;
                                }
                                returnedElements = new Object[numPartitions];
                                int offset = 0;
                                int length = 0;
                                int baseIndex = indxValue.getInitialOffset();
                                int childrenLeft = indxValue.getSize();
                                int i = 0;
                                while (i < numPartitions) {
                                    offset = i * partitionSize + baseIndex;
                                    length = childrenLeft > partitionSize ? partitionSize : childrenLeft;
                                    returnedElements[i] = new PDTIndexedVariablePartition((IDebugElement)variable, indxValue, offset, length);
                                    childrenLeft -= length;
                                    ++i;
                                }
                                partitionedVar.setPartitionCache(returnedElements);
                            }
                        }
                        sort = false;
                    }
                } else if (((NodeValue)value).isVariablesRetrieved()) {
                    returnedElements = value.getVariables();
                } else {
                    returnedElements = PENDING;
                    super.getChildren(variable);
                }
            }
            catch (DebugException e) {
                PICLUtils.logError((Exception)((Object)e));
                returnedElements = EMPTYOBJECTS;
            }
        }
        if (sort) {
            Arrays.sort(returnedElements);
        }
        return returnedElements;
    }

    @Override
    protected Object[] getChildrenJob(BasicDebugViewContentProvider contentProvider, IDebugElement parent) throws Exception {
        IVariable variable = (IVariable)parent;
        Object[] returnedElements = variable.getValue().getVariables();
        if (variable instanceof PDTIndexedVariablePartition) {
            ((PDTIndexedVariablePartition)variable).setValuesRetrieved(true);
        }
        return returnedElements;
    }

    private int computePartitionSize(IIndexedValue value) {
        int numElements = 0;
        try {
            numElements = value.getSize();
        }
        catch (DebugException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        int i = 100;
        while (i < Integer.MAX_VALUE) {
            if (numElements <= i) {
                return i / 100;
            }
            i *= 100;
        }
        return 1;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof PDTIndexedVariablePartition) {
            return true;
        }
        return ((PDTDebugElement)element).hasChildren();
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof PDTIndexedVariablePartition) {
            return ((PDTIndexedVariablePartition)((Object)element)).getParent();
        }
        return ((PDTDebugElement)element).getParentElement();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("display_values_on_array_structs")) {
            this.refresh();
        }
    }
}

