/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.views.BasicDebugViewContentProvider;
import com.ibm.debug.pdt.internal.ui.views.ModulesView;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;

public class ModulesContentProvider
extends BasicDebugViewContentProvider {
    private ModulesView fView;

    public ModulesContentProvider(ModulesView view) {
        this.fView = view;
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString(this, " Creating");
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    protected void doHandleDebugEvent(DebugEvent event) {
        if (this.isDisposed()) {
            return;
        }
        Object obj = event.getSource();
        if (event.getKind() == 8 && obj instanceof DebuggeeProcess) {
            this.fViewer.setInput(null);
            this.fView.showMessage(ModulesView.MODULES_NOT_AVAILABLE);
            this.fView.showMsg = true;
        }
        if (obj instanceof PICLModule) {
            switch (event.getKind()) {
                case 4: {
                    this.fViewer.add((Object)((PICLModule)obj).getParentElement(), obj);
                    break;
                }
                case 16: {
                    this.refresh(obj);
                    break;
                }
                case 8: {
                    this.fViewer.remove(obj);
                    break;
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fView = null;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }
}

