/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import com.ibm.debug.pdt.internal.ui.util.IStringButtonAdapter;
import com.ibm.debug.pdt.internal.ui.util.StringCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StringComboButton
extends StringCombo {
    private Button fBrowseButton;
    private String fBrowseButtonLabel;
    private IStringButtonAdapter fStringButtonAdapter;
    private boolean fButtonEnabled;

    public StringComboButton(IStringButtonAdapter adapter) {
        this.fStringButtonAdapter = adapter;
        this.fBrowseButtonLabel = PICLLabels.browse;
        this.fButtonEnabled = true;
    }

    public StringComboButton(IStringButtonAdapter adapter, boolean labelBesideField) {
        super(labelBesideField);
        this.fStringButtonAdapter = adapter;
        this.fBrowseButtonLabel = PICLLabels.browse;
        this.fButtonEnabled = true;
    }

    public void setButtonLabel(String label) {
        this.fBrowseButtonLabel = label;
    }

    public void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringComboButton.gridDataForLabel(1));
        Control space = null;
        if (!this.fLabelBeside && nColumns > 1) {
            space = DialogField.createEmptySpace(parent, nColumns - 1);
        }
        Combo combo = this.getComboControl(parent);
        if (this.fLabelBeside) {
            combo.setLayoutData((Object)StringComboButton.gridDataForCombo(nColumns - 2));
        } else {
            combo.setLayoutData((Object)StringComboButton.gridDataForCombo(nColumns - 1));
        }
        Control button = this.getChangeControl(parent);
        button.setLayoutData((Object)StringComboButton.gridDataForControl(1));
        if (space == null) {
            return new Control[]{label, combo, button};
        }
        return new Control[]{label, space, combo, button};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForControl(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public Control getChangeControl(Composite parent) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(parent);
            this.fBrowseButton = new Button(parent, 8);
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    StringComboButton.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StringComboButton.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

