/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.util.DialogField;
import com.ibm.debug.pdt.internal.ui.util.IStringButtonAdapter;
import com.ibm.debug.pdt.internal.ui.util.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringButtonDialogField
extends StringDialogField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel;
    private IStringButtonAdapter fStringButtonAdapter;
    private boolean fButtonEnabled;

    public StringButtonDialogField(IStringButtonAdapter adapter) {
        this.fStringButtonAdapter = adapter;
        this.fBrowseButtonLabel = PICLLabels.browse;
        this.fButtonEnabled = true;
    }

    public StringButtonDialogField(IStringButtonAdapter adapter, boolean labelBesideField) {
        super(labelBesideField);
        this.fStringButtonAdapter = adapter;
        this.fBrowseButtonLabel = PICLLabels.browse;
        this.fButtonEnabled = true;
    }

    public void setButtonLabel(String label) {
        this.fBrowseButtonLabel = label;
    }

    public void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control space = null;
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        if (!this.fLabelBeside && nColumns > 1) {
            space = DialogField.createEmptySpace(parent, nColumns - 1);
        }
        Text text = this.getTextControl(parent);
        if (this.fLabelBeside) {
            text.setLayoutData((Object)StringButtonDialogField.gridDataForText(nColumns - 2));
        } else {
            text.setLayoutData((Object)StringButtonDialogField.gridDataForText(nColumns - 1));
        }
        Control button = this.getChangeControl(parent);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForControl(1));
        if (space == null) {
            return new Control[]{label, text, button};
        }
        return new Control[]{label, space, text, button};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForControl(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public Control getChangeControl(Composite parent) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(parent);
            this.fBrowseButton = new Button(parent, 8);
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

