/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.rsecommon.IInlineVariableTreeEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DefaultInlineVariableTreeEditor
implements IInlineVariableTreeEditor {
    protected Composite fComposite;
    protected Tree fTree;
    protected Label fEditorLabel;
    protected Text fEditorText;
    protected TreeEditor fTreeEditor;
    protected IVariable fVariable;
    protected boolean crEvent;

    protected Text createTextField(Composite composite) {
        int textStyles = 16388;
        if (SWT.getPlatform().equals("win32")) {
            textStyles |= 0x800;
        }
        return new Text(composite, textStyles);
    }

    protected String getValueDisplayText(IVariable variable) throws DebugException {
        return variable.getValue().getValueString();
    }

    public void editVariable(Tree tree, IVariable variable) {
        if (tree == null || variable == null) {
            return;
        }
        this.fTree = tree;
        this.fTreeEditor = new TreeEditor(this.fTree);
        this.fVariable = variable;
        this.fComposite = new Composite((Composite)this.fTree, 0);
        this.fComposite.setBackground(this.fTree.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fEditorLabel = new Label(this.fComposite, 16384);
        this.fEditorLabel.setLayoutData((Object)new GridData(1040));
        this.fEditorText = this.createTextField(this.fComposite);
        this.fEditorText.setLayoutData((Object)new GridData(1808));
        String valueString = "";
        try {
            valueString = this.getValueDisplayText(this.fVariable);
        }
        catch (DebugException de) {
            ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)PICLLabels.ErrorDialog_title, (String)PICLLabels.picl_value_error_no_value_available, (IStatus)de.getStatus());
        }
        TreeItem[] selectedItems = this.fTree.getSelection();
        this.fTreeEditor.horizontalAlignment = 16384;
        this.fTreeEditor.grabHorizontal = true;
        this.fTreeEditor.setEditor((Control)this.fComposite, selectedItems[0]);
        String varName = "";
        try {
            varName = this.fVariable.getName();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        this.fEditorLabel.setText(varName + "=");
        this.fEditorText.setText(valueString);
        this.fEditorText.selectAll();
        this.fComposite.layout(true);
        this.fComposite.setVisible(true);
        this.fEditorText.setFocus();
        this.fEditorText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    DefaultInlineVariableTreeEditor.this.crEvent = true;
                    DefaultInlineVariableTreeEditor.this.saveChangesAndCleanup(DefaultInlineVariableTreeEditor.this.fVariable);
                }
                if (event.character == '\u001b') {
                    DefaultInlineVariableTreeEditor.this.cleanup();
                }
            }
        });
        this.fEditorText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                if (!DefaultInlineVariableTreeEditor.this.crEvent) {
                    DefaultInlineVariableTreeEditor.this.saveChangesAndCleanup(DefaultInlineVariableTreeEditor.this.fVariable);
                }
                DefaultInlineVariableTreeEditor.this.crEvent = false;
            }
        });
    }

    protected void saveChangesAndCleanup(final IVariable variable) {
        final String newValue = this.fEditorText.getText();
        Job saveVariableJob = new Job("Changing Variable Value"){

            protected IStatus run(IProgressMonitor arg0) {
                try {
                    if (!variable.getValue().getValueString().equals(newValue)) {
                        variable.setValue(newValue);
                    }
                }
                catch (DebugException de) {
                    PICLDebugPlugin.showMessageDialog(null, 1, de.getMessage(), false);
                }
                catch (Exception e) {
                    PICLUtils.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        saveVariableJob.setSystem(true);
        saveVariableJob.schedule();
        this.cleanup();
    }

    protected void cleanup() {
        if (this.fEditorText != null) {
            this.fEditorText.dispose();
            this.fEditorText = null;
            this.fVariable = null;
            this.fTreeEditor.setEditor(null, null);
            this.fComposite.setVisible(false);
        }
    }
}

