/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DebugConsoleUtils {
    private static final String EMPTY = "";

    public static String getLineDelimiter() {
        return Text.DELIMITER;
    }

    public static String[] toArray(String cmds) {
        return DebugConsoleUtils.toArray(cmds, DebugConsoleUtils.getLineDelimiter());
    }

    public static String[] toArray(String cmds, String delimiter) {
        if (cmds == null || cmds.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(cmds, delimiter);
        int count = tokenizer.countTokens();
        String[] cmdList = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdList[i] = tokenizer.nextToken();
            ++i;
        }
        return cmdList;
    }

    public static String formatCommandLogViewerCommand(String cmd, int index) {
        String indexString = Integer.toString(index);
        String fiveSpaces = "     ";
        return indexString + fiveSpaces + cmd;
    }

    static String[] addDelimiter(String[] cmds) {
        int i = 0;
        while (i < cmds.length - 1) {
            cmds[i] = cmds[i] + Text.DELIMITER;
            ++i;
        }
        return cmds;
    }

    public static String removeCommand(String commands, int index) {
        String[] cmdsArray = DebugConsoleUtils.toArray(commands);
        ArrayList<String> cmds = new ArrayList<String>(Arrays.asList(cmdsArray));
        if (index < 0 || index > cmdsArray.length) {
            return EMPTY;
        }
        cmds.remove(index);
        cmds.trimToSize();
        cmdsArray = cmds.toArray(new String[cmds.size()]);
        DebugConsoleUtils.addDelimiter(cmdsArray);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cmdsArray.length) {
            buf.append(cmdsArray[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String insertCommand(String commands, String targetCommand, String movedCommand) {
        String currentCommands = null;
        StringBuffer cmds = new StringBuffer(commands);
        int index = cmds.indexOf(movedCommand);
        currentCommands = cmds.substring(0, index) + targetCommand + Text.DELIMITER + cmds.substring(index);
        return currentCommands;
    }

    public static StringBuffer getImportedCommandsFromFile(Shell parent) {
        FileDialog fileDialog = new FileDialog(parent, 4096);
        StringBuffer cmdsBuffer = new StringBuffer();
        String path = fileDialog.open();
        if (path != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(path), Charset.defaultCharset());){
                    int i;
                    while ((i = ((Reader)fileReader).read()) != -1) {
                        cmdsBuffer.append(String.valueOf((char)i));
                    }
                    ((Reader)fileReader).close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
        }
        return cmdsBuffer;
    }

    public static String getExportFilePath(Shell parent) {
        MessageBox mb;
        FileDialog fileSaveDialog = new FileDialog(parent, 8192);
        String fileSavePath = null;
        do {
            if ((fileSavePath = fileSaveDialog.open()) == null) {
                return null;
            }
            File file = new File(fileSavePath);
            if (!file.exists()) break;
            mb = new MessageBox(fileSaveDialog.getParent(), 200);
            mb.setMessage(NLS.bind((String)PICLMessages.DebugConsoleViewOverwritePrompt, (Object)fileSavePath));
            mb.setText(PICLLabels.DebugConsoleViewExportMBTitle);
        } while (mb.open() != 64);
        return fileSavePath;
    }

    public static String cleanLine(String line) {
        if (!((String)line).endsWith(DebugConsoleUtils.getLineDelimiter())) {
            int idx = ((String)line).length() - 1;
            while (((String)line).charAt(idx) == '\n' || ((String)line).charAt(idx) == '\r') {
                --idx;
            }
            line = ((String)line).substring(0, idx + 1) + DebugConsoleUtils.getLineDelimiter();
        }
        return line;
    }
}

