/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.ui.dialogs.ICheckedListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CheckedList
extends Composite {
    List<ICheckedListItem> fAllElements = Collections.emptyList();
    private ArrayList<ICheckedListItem> fFilteredElements = new ArrayList();
    boolean fMutuallyExclusive;
    private boolean fIgnoreCase;
    private String fRememberedMatchText = "";
    private Table fTable;
    private Text fText;
    private boolean fSort;

    public CheckedList(Composite parent, boolean ignoreCase, boolean isMutuallyExclusive) {
        this(parent, ignoreCase, isMutuallyExclusive, true);
    }

    public CheckedList(Composite parent, boolean ignoreCase, boolean isMutallyExclusive, boolean sort) {
        super(parent, 0);
        this.fIgnoreCase = ignoreCase;
        this.fMutuallyExclusive = isMutallyExclusive;
        this.fSort = sort;
        this.setLayout((Layout)new GridLayout());
        this.createText();
        this.createList();
    }

    private void createList() {
        this.fTable = new Table((Composite)this, 2080);
        this.fTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.fTable.addSelectionListener(new SelectionListener(){

            private void handleSelectionEvent(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem tblItem = (TableItem)e.item;
                    ICheckedListItem item = (ICheckedListItem)tblItem.getData();
                    if (tblItem.getChecked()) {
                        if (CheckedList.this.fMutuallyExclusive) {
                            for (ICheckedListItem iterItem : CheckedList.this.fAllElements) {
                                iterItem.setEnabled(false);
                            }
                            item.setEnabled(true);
                            CheckedList.this.updateListWidget();
                        } else {
                            item.setEnabled(true);
                        }
                    } else if (CheckedList.this.fMutuallyExclusive && item.isEnabled()) {
                        CheckedList.this.updateListWidget();
                    } else {
                        item.setEnabled(false);
                    }
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.handleSelectionEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelectionEvent(e);
            }
        });
    }

    private void createText() {
        this.fText = new Text((Composite)this, 2048);
        this.fText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CheckedList.this.filter(false);
            }
        });
    }

    public void filter(boolean forceUpdate) {
        String filterText = this.getFilter();
        if (!forceUpdate && filterText.equals(this.fRememberedMatchText)) {
            return;
        }
        this.fFilteredElements.clear();
        this.fRememberedMatchText = filterText;
        filterText = filterText.replaceAll("\\*", ".*");
        filterText = filterText.replaceAll("\\?", ".");
        String regex = filterText + ".*";
        Pattern pattern = null;
        try {
            pattern = this.fIgnoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (pattern != null) {
            String label = null;
            Matcher matcher = null;
            for (ICheckedListItem item : this.fAllElements) {
                label = item.getLabel();
                matcher = pattern.matcher(label);
                if (!matcher.matches()) continue;
                this.fFilteredElements.add(item);
            }
        }
        this.updateListWidget();
    }

    public String getFilter() {
        return this.fText.getText();
    }

    public void selectFilterText() {
        this.fText.selectAll();
    }

    public void setElements(ICheckedListItem[] items) {
        this.fAllElements = Arrays.asList(items);
        if (this.fSort) {
            Collections.sort(this.fAllElements);
        }
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.fText.setEnabled(enable);
        this.fTable.setEnabled(enable);
    }

    public void setFilter(String pattern, boolean refilter) {
        this.fText.setText(pattern);
        if (refilter) {
            this.filter(true);
        }
    }

    public boolean setFocus() {
        return this.fText.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fText.setFont(font);
        this.fTable.setFont(font);
    }

    void updateListWidget() {
        if (this.fTable == null || this.fTable.isDisposed()) {
            return;
        }
        this.fTable.setRedraw(false);
        int tableCount = this.fTable.getItemCount();
        int itemsCount = this.fFilteredElements.size();
        if (itemsCount == 0) {
            this.fTable.removeAll();
        } else if (tableCount > itemsCount) {
            this.fTable.remove(itemsCount, tableCount - 1);
        } else if (tableCount < itemsCount) {
            int numToAdd = itemsCount - tableCount;
            int i = 0;
            while (i < numToAdd) {
                new TableItem(this.fTable, 0);
                ++i;
            }
        }
        TableItem[] tableItems = this.fTable.getItems();
        Iterator<ICheckedListItem> iter = this.fFilteredElements.iterator();
        int i = 0;
        while (i < tableItems.length) {
            ICheckedListItem item = iter.next();
            TableItem tblItem = tableItems[i];
            tblItem.setData((Object)item);
            tblItem.setText(item.getLabel());
            tblItem.setChecked(item.isEnabled());
            ++i;
        }
        if (this.fTable.getItemCount() > 0) {
            this.fTable.setSelection(0);
        }
        this.fTable.setRedraw(true);
    }

    public void checkAll() {
        Iterator<ICheckedListItem> iter = this.fFilteredElements.iterator();
        while (iter.hasNext()) {
            iter.next().setEnabled(true);
        }
        this.updateListWidget();
    }

    public void uncheckAll() {
        Iterator<ICheckedListItem> iter = this.fFilteredElements.iterator();
        while (iter.hasNext()) {
            iter.next().setEnabled(false);
        }
        this.updateListWidget();
    }

    public void restoreDefaults() {
        Iterator<ICheckedListItem> iter = this.fAllElements.iterator();
        while (iter.hasNext()) {
            iter.next().setDefaultEnabledState();
        }
        this.updateListWidget();
    }
}

