/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.sourcelocator;

import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.pdt.internal.ui.sourcelocator.RemoteEnginePathContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RemoteEnginePathBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        RemoteEnginePathDialog dialog;
        String existingEnginePath = null;
        RemoteEnginePathContainer enginePathContainer = PICLUtils.getDebugEnginePathContainer(director);
        if (enginePathContainer != null) {
            existingEnginePath = enginePathContainer.getPath();
        }
        if ((dialog = new RemoteEnginePathDialog(shell, existingEnginePath)).open() == 0) {
            String dialogPath = dialog.getPath();
            if (enginePathContainer == null) {
                enginePathContainer = new RemoteEnginePathContainer(dialogPath);
                enginePathContainer.init(director);
            } else {
                enginePathContainer.setPath(dialogPath);
            }
            IPDTDebugTarget dbgtgt = PDTCorePlugin.getDebugTarget((ISourceLookupDirector)director);
            if (dbgtgt instanceof PDTDebugTarget) {
                DebugEngine debugEngine = dbgtgt.getDebugEngine();
                if (debugEngine != null && ((PDTDebugTarget)dbgtgt).supportsUpdateEngineSearchPath()) {
                    try {
                        debugEngine.updateEnginePaths(dialogPath);
                    }
                    catch (EngineRequestException ere) {
                        PICLUtils.logError((Exception)((Object)ere));
                    }
                } else {
                    PICLDebugPlugin.showMessageDialog(null, 4, PICLMessages.sourcelocation_debugEnginePath_changeWarning, false);
                }
            }
            return new ISourceContainer[]{enginePathContainer};
        }
        return null;
    }

    public boolean canEditSourceContainers(ISourceLookupDirector director, ISourceContainer[] containers) {
        return containers != null && containers[0] instanceof RemoteEnginePathContainer;
    }

    public ISourceContainer[] editSourceContainers(Shell shell, ISourceLookupDirector director, ISourceContainer[] containers) {
        RemoteEnginePathContainer enginePathContainer;
        String existingEnginePath;
        RemoteEnginePathDialog dialog;
        if (containers != null && containers[0] instanceof RemoteEnginePathContainer && (dialog = new RemoteEnginePathDialog(shell, existingEnginePath = (enginePathContainer = (RemoteEnginePathContainer)containers[0]).getPath())).open() == 0) {
            String dialogPath = dialog.getPath();
            enginePathContainer.setPath(dialogPath);
            IPDTDebugTarget dbgtgt = PDTCorePlugin.getDebugTarget((ISourceLookupDirector)director);
            if (dbgtgt instanceof PDTDebugTarget) {
                DebugEngine debugEngine = dbgtgt.getDebugEngine();
                if (debugEngine != null && ((PDTDebugTarget)dbgtgt).supportsUpdateEngineSearchPath()) {
                    try {
                        debugEngine.updateEnginePaths(dialogPath);
                    }
                    catch (EngineRequestException ere) {
                        PICLUtils.logError((Exception)((Object)ere));
                    }
                } else {
                    PICLDebugPlugin.showMessageDialog(null, 4, PICLMessages.sourcelocation_debugEnginePath_changeWarning, false);
                }
            }
        }
        return containers;
    }

    static class RemoteEnginePathDialog
    extends DebugTrayDialog {
        private String fPath;
        private Text fPathField;

        RemoteEnginePathDialog(Shell shell, String path) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fPath = path == null ? "" : path;
        }

        protected Control createDialogArea(Composite parent) {
            parent.getShell().setText(PICLLabels.sourcelocation_debugEnginePath_dialog_addTitle);
            Composite comp = (Composite)super.createDialogArea(parent);
            Label l = new Label(comp, 0);
            l.setText(PICLLabels.sourcelocation_debugEnginePath_dialog_addDesc1);
            this.fPathField = new Text(comp, 2048);
            GridData gd = new GridData(768);
            this.fPathField.setLayoutData((Object)gd);
            this.fPathField.setText(this.fPath);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("remote_engine_path_browser"));
            return comp;
        }

        protected void okPressed() {
            this.fPath = this.fPathField.getText();
            super.okPressed();
        }

        void setPath(String path) {
            this.fPath = path;
        }

        String getPath() {
            return this.fPath;
        }
    }
}

