/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.sourcelocator;

import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.EngineEditorFile;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.IModuleEventListener;
import com.ibm.debug.pdt.internal.core.model.IPartEventListener;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.ModuleUnloadedEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.PartAddedEvent;
import com.ibm.debug.pdt.internal.core.model.PartChangedEvent;
import com.ibm.debug.pdt.internal.core.model.PartDeletedEvent;
import com.ibm.debug.pdt.internal.core.model.View;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PDTModelPresentation;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.ChangeTextFileDialog;
import com.ibm.debug.pdt.internal.ui.sourcelocator.PDTSourceNotFoundEditorInput;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class PDTSourceNotFoundEditor
extends CommonSourceNotFoundEditor {
    private ILaunchesListener2 fPDTLaunchesListener;
    private final IModuleEventListener fPDTModuleEventListener = new IModuleEventListener(){

        public void partAdded(PartAddedEvent event) {
        }

        public void partDeleted(PartDeletedEvent event) {
            if (event.getPart().equals(PDTSourceNotFoundEditor.this.fPart)) {
                PDTSourceNotFoundEditor.this.closeEditor();
            }
        }

        public void moduleUnloaded(ModuleUnloadedEvent event) {
            if (event.getModule().equals(PDTSourceNotFoundEditor.this.fModule)) {
                PDTSourceNotFoundEditor.this.closeEditor();
            }
        }
    };
    private final IPartEventListener fPartEventListener = new IPartEventListener(){

        public void partChanged(PartChangedEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PICLUtils.resetEditor(PDTSourceNotFoundEditor.this.getArtifact(), PDTSourceNotFoundEditor.this.getEditorSite().getPage(), 0);
                }
            });
        }
    };
    private Part fPart;
    private Module fModule;

    public void dispose() {
        IEditorInput oldInput;
        if (this.fPDTLaunchesListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fPDTLaunchesListener);
        }
        if ((oldInput = this.getEditorInput()) instanceof PDTSourceNotFoundEditorInput && this.fModule != null) {
            this.fModule.removeListener((IModelEventListener)this.fPDTModuleEventListener);
        }
        if (this.fPart != null) {
            this.fPart.removeListener((IModelEventListener)this.fPartEventListener);
        }
        super.dispose();
    }

    protected void initialize() {
        this.fPDTLaunchesListener = new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                Object artifact = PDTSourceNotFoundEditor.this.getArtifact();
                int i = 0;
                while (i < launches.length) {
                    ILaunch launch = launches[i];
                    if (artifact instanceof IDebugElement) {
                        if (launch.equals(((IDebugElement)artifact).getLaunch())) {
                            PDTSourceNotFoundEditor.this.closeEditor();
                            return;
                        }
                    } else if (artifact instanceof PICLBreakpoint && launch.getDebugTarget().equals(((PICLBreakpoint)artifact).getDebugTarget())) {
                        PDTSourceNotFoundEditor.this.closeEditor();
                        return;
                    }
                    ++i;
                }
            }

            public void launchesRemoved(ILaunch[] launches) {
                this.launchesTerminated(launches);
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fPDTLaunchesListener);
    }

    public void createPartControl(Composite parent) {
        View nextView;
        super.createPartControl(parent);
        PDTSourceNotFoundEditorInput ei = (PDTSourceNotFoundEditorInput)this.getEditorInput();
        ViewFile vf = ei.getViewFile();
        if (vf.canFileNameBeOverridden()) {
            Button button = new Button(parent, 8);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = false;
            data.heightHint = 50;
            data.widthHint = 50;
            button.setData((Object)data);
            button.setText(PICLLabels.sourceNotFoundButton_changeSource);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    PDTSourceNotFoundEditorInput nfei = (PDTSourceNotFoundEditorInput)PDTSourceNotFoundEditor.this.getEditorInput();
                    ViewFile viewFile = nfei.getViewFile();
                    EngineEditorFile engineFile = new EngineEditorFile(viewFile, PDTModelPresentation.useCopyOfLocalFile(viewFile));
                    viewFile.setContext(PDTSourceNotFoundEditor.this.getArtifact());
                    EngineSuppliedViewEditorInput esvInput = new EngineSuppliedViewEditorInput((AbstractEditorFile)engineFile, viewFile);
                    ChangeTextFileDialog dialog = new ChangeTextFileDialog(CommonUtils.getShell(), esvInput);
                    if (dialog.open() == 0) {
                        PICLUtils.resetEditor(PDTSourceNotFoundEditor.this.getArtifact(), PDTSourceNotFoundEditor.this.getEditorSite().getPage(), 0);
                    }
                }
            });
        }
        if ((nextView = this.fPart.getNextView()) != null) {
            Button viewButton = new Button(parent, 8);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = false;
            gd.grabExcessVerticalSpace = false;
            gd.heightHint = 50;
            gd.widthHint = 50;
            viewButton.setData((Object)gd);
            viewButton.setText(NLS.bind((String)PICLLabels.sourceNotFoundButton_showView, (Object)nextView.getViewInformation().getName()));
            viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Object artifact = PDTSourceNotFoundEditor.this.getArtifact();
                    if (artifact instanceof IDebugLocationProvider) {
                        ViewFile viewFile = ((IDebugLocationProvider)artifact).getViewFile();
                        viewFile.getPart().setCurrentView(nextView);
                        if (viewFile.getEngineSession().iszTPFengine()) {
                            try {
                                viewFile.getDebugEngine().switchView(new Location(viewFile, 1), nextView.getViewInformation());
                            }
                            catch (EngineRequestException e) {
                                PDTCoreUtils.logString((Object)((Object)this), (String)"TPF engine failed to switch view", (int)2, (Exception)((Object)e));
                            }
                        }
                    }
                    PICLUtils.resetEditor(artifact, PDTSourceNotFoundEditor.this.getEditorSite().getPage(), 0);
                }
            });
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PICLUtils.getHelpResourceString("debugger_editor_no_source_pdt"));
    }

    public void setInput(IEditorInput newInput) {
        IEditorInput oldInput = this.getEditorInput();
        super.setInput(newInput);
        if (newInput.equals(oldInput)) {
            return;
        }
        if (this.fModule != null) {
            this.fModule.removeListener((IModelEventListener)this.fPDTModuleEventListener);
            this.fModule = null;
            if (this.fPart != null) {
                this.fPart.removeListener((IModelEventListener)this.fPartEventListener);
            }
            this.fPart = null;
        }
        try {
            ViewFile vf = ((PDTSourceNotFoundEditorInput)newInput).getViewFile();
            this.fPart = vf.getPart();
            this.fPart.addListener((IModelEventListener)this.fPartEventListener);
            this.fModule = this.fPart.getModule();
            this.fModule.addEventListener(this.fPDTModuleEventListener);
        }
        catch (Exception e) {
            this.fModule = null;
            this.fPart = null;
        }
    }
}

