/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.sourcelocator;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.sourcelocator.PDTLookupResult;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PDTLookupResultAdapter
implements IWorkbenchAdapter {
    private PDTLookupResult fResult;
    private static final Object[] EMPTYCHILDREN = new Object[0];

    public PDTLookupResultAdapter(PDTLookupResult result) {
        this.fResult = result;
    }

    public Object[] getChildren(Object o) {
        return EMPTYCHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        Object sourceFile = this.fResult.getSourceFile();
        if (sourceFile instanceof ViewFile) {
            ViewFile vf = (ViewFile)sourceFile;
            String baseName = vf.getBaseFileName();
            String tmp = vf.getFileName();
            int idx = tmp.lastIndexOf(baseName);
            if (idx > 0) {
                tmp = tmp.substring(0, idx - 1);
            }
            return PICLLabels.sourcelocation_debugEngine_label + ": " + baseName + " - " + tmp;
        }
        if (sourceFile instanceof IAdaptable) {
            IResource resource;
            if (sourceFile instanceof IResource && (resource = (IResource)sourceFile).getName() != null && resource.getFullPath() != null) {
                return resource.getName() + " - " + resource.getFullPath().toString();
            }
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)sourceFile).getAdapter(IWorkbenchAdapter.class);
            if (adapter != null) {
                return adapter.getLabel(sourceFile);
            }
        }
        return PICLLabels.picl_stack_frame_label_unknown;
    }

    public Object getParent(Object o) {
        return null;
    }
}

