/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.sourcelocator;

import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.ui.IWorkbenchPage;

public class DebuggeeThreadSourceDisplayAdapter
implements ISourceDisplay {
    private static DebuggeeThreadSourceDisplayAdapter fgInstance = new DebuggeeThreadSourceDisplayAdapter();

    private DebuggeeThreadSourceDisplayAdapter() {
    }

    public static DebuggeeThreadSourceDisplayAdapter getInstance() {
        return fgInstance;
    }

    public void displaySource(final Object element, final IWorkbenchPage page, final boolean forceSourceLookup) {
        final DebuggeeThread thread = (DebuggeeThread)element;
        Job displaySourceJob = new Job("Display Source"){

            protected IStatus run(IProgressMonitor monitor) {
                ISourceDisplay sourceDisplay;
                IStackFrame topStackFrame = null;
                try {
                    topStackFrame = thread.getTopStackFrame();
                }
                catch (DebugException e) {
                    PDTCoreUtils.logString((Object)element, (String)": could not get the thread's top stack frame", (int)1, (Exception)((Object)e));
                }
                if (topStackFrame != null && (sourceDisplay = (ISourceDisplay)topStackFrame.getAdapter(ISourceDisplay.class)) != null) {
                    sourceDisplay.displaySource((Object)topStackFrame, page, forceSourceLookup);
                }
                return Status.OK_STATUS;
            }
        };
        displaySourceJob.schedule();
    }
}

