/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.properties;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.StackColumnDetails;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.properties.PropertySourceAdapter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class StackFramePropertySourceAdapter
extends PropertySourceAdapter {
    private StackFrame fSource;

    public StackFramePropertySourceAdapter(StackFrame source) {
        this.fSource = source;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fSource.haveDoneCleanup()) {
            return EMPTYDESCRIPTORS;
        }
        final IPropertyDescriptor[][] returnValue = new IPropertyDescriptor[][]{EMPTYDESCRIPTORS};
        Job getPropertiesJob = new Job("Get Properties"){

            protected IStatus run(IProgressMonitor arg0) {
                DebugEngine engine = StackFramePropertySourceAdapter.this.fSource.getDebugEngine();
                if (engine == null || !engine.isConnected() || engine.haveDoneCleanup()) {
                    return Status.OK_STATUS;
                }
                ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
                StackColumnDetails[] stackColumnDetailsArray = engine.getStackDetails();
                int n = stackColumnDetailsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackColumnDetails column = stackColumnDetailsArray[n2];
                    String columnName = column.getColumnName();
                    if (PDTCoreUtils.isEmpty((String)columnName)) {
                        columnName = PICLLabels.picl_stack_frame_label_unknown;
                    }
                    list.add(new PropertyDescriptor((Object)list.size(), columnName));
                    ++n2;
                }
                returnValue[0] = list.toArray(new IPropertyDescriptor[list.size()]);
                return Status.OK_STATUS;
            }
        };
        getPropertiesJob.schedule();
        try {
            getPropertiesJob.join();
        }
        catch (InterruptedException e1) {
            return EMPTYDESCRIPTORS;
        }
        return returnValue[0];
    }

    public Object getPropertyValue(Object id) {
        try {
            int columnId = (Integer)id;
            if (columnId < this.fSource.getColumns().length) {
                return this.fSource.getColumns()[columnId];
            }
            return PICLLabels.picl_stack_frame_label_unknown;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

