/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.properties;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.ui.properties.PropertySourceAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ModulePropertySourceAdapter
extends PropertySourceAdapter {
    private static final String MODULE_NAME = "picl_module_module_name";
    private static final String DEBUG_INFO = "picl_module_debug_info";
    private static final String QUAL_NAME = "picl_module_qualified_name";
    private static final String INFO_MSG = "picl_module_info_msg";
    private PICLModule fSource;

    public ModulePropertySourceAdapter(PICLModule source) {
        this.fSource = source;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fSource.haveDoneCleanup()) {
            return EMPTYDESCRIPTORS;
        }
        try {
            IPropertyDescriptor[] pdlist = new IPropertyDescriptor[]{new PropertyDescriptor((Object)MODULE_NAME, PICLLabels.picl_module_module_name), new PropertyDescriptor((Object)DEBUG_INFO, PICLLabels.picl_module_debug_info), new PropertyDescriptor((Object)QUAL_NAME, PICLLabels.picl_module_qualified_name), new PropertyDescriptor((Object)INFO_MSG, PICLLabels.MessageDialog_title_Informational)};
            return pdlist;
        }
        catch (NullPointerException nullPointerException) {
            return EMPTYDESCRIPTORS;
        }
    }

    public Object getPropertyValue(Object id) {
        try {
            Module module = this.fSource.getModule();
            if (id.equals(MODULE_NAME)) {
                return module.getName();
            }
            if (id.equals(DEBUG_INFO)) {
                return module.hasDebugInfo();
            }
            if (id.equals(QUAL_NAME)) {
                return module.getQualifiedName();
            }
            if (id.equals(INFO_MSG)) {
                return module.getInformationalMsg();
            }
            return "*unknown*";
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

