/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.preferences;

import com.ibm.debug.pdt.internal.epdc.EPDCUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceUI {
    private static ScopedPreferenceStore fPDTPreferenceStore = null;

    public static ScopedPreferenceStore getPreferenceStore() {
        if (fPDTPreferenceStore == null) {
            fPDTPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.ibm.debug.pdt.ui");
        }
        return fPDTPreferenceStore;
    }

    public static boolean isSocketTimeoutEnabled() {
        return PreferenceUI.getPreferenceStore().getBoolean("socket_timeout");
    }

    public static int getSocketTimeout() {
        return PreferenceUI.getPreferenceStore().getInt("socket_timeout_sec");
    }

    public static byte getTerminateType() {
        String abendPref = PreferenceUI.getPreferenceStore().getString("preference.terminate");
        if (abendPref.equals("abend")) {
            return 2;
        }
        return 0;
    }

    public static int getDisconnectType() {
        String disconnect = PreferenceUI.getPreferenceStore().getString("preference.disconnect");
        if (disconnect.equals("ProcessPrompt")) {
            return Integer.MAX_VALUE;
        }
        if (disconnect.equals("ProcessKill")) {
            return 2;
        }
        if (disconnect.equals("ProcessKeep")) {
            return 1;
        }
        return 0;
    }

    public static String getGlobalEnginePath() {
        return PreferenceUI.getPreferenceStore().getString("global_engine_path");
    }

    public static boolean isUseDefaultEditor() {
        return !PreferenceUI.getPreferenceStore().getBoolean("always_use_debugger_editor");
    }

    public static boolean isUseDebuggerEditorWhenLargeFile() {
        return PreferenceUI.getPreferenceStore().getBoolean("use_debugger_editor_when_large_file");
    }

    public static int getSourceFileLineNumberLimit() {
        return PreferenceUI.getPreferenceStore().getInt("line_number_limit");
    }

    public static boolean isLoadEntireFile() {
        return PreferenceUI.getPreferenceStore().getBoolean("load_entire_file");
    }

    public static boolean isAllowHover() {
        return PreferenceUI.getPreferenceStore().getBoolean("allow_hover_evaluation");
    }

    public static boolean isDisplayHoverTypes() {
        return PreferenceUI.getPreferenceStore().getBoolean("display_hover_types");
    }

    public static boolean isDoubleClickAddMonitor() {
        return PreferenceUI.getPreferenceStore().getBoolean("double_click_to_add_monitor");
    }

    public static boolean isDoubleClickAddMonitorGeneral() {
        return PreferenceUI.getPreferenceStore().getBoolean("double_click_to_add_monitor_general");
    }

    public static boolean isCenterOnExecution() {
        return PreferenceUI.getPreferenceStore().getBoolean("center_view_execution");
    }

    public static RGB getExecutionLineColor() {
        String color = PreferenceUI.getPreferenceStore().getString("execution_line_colour");
        if (color == null) {
            return new RGB(0, 255, 255);
        }
        return StringConverter.asRGB((String)color);
    }

    public static RGB getDefaultExecutionLineColor() {
        String color = PreferenceUI.getPreferenceStore().getDefaultString("execution_line_colour");
        if (color == null) {
            return new RGB(0, 255, 255);
        }
        return StringConverter.asRGB((String)color);
    }

    public static boolean isSaveExceptionsByProfile() {
        return PreferenceUI.getPreferenceStore().getBoolean("save_exceptions_by_profile");
    }

    public static String getSwitchPerspectiveID() {
        return PreferenceUI.getPreferenceStore().getString("switch_perspective_id");
    }

    public static void setSwitchPerspectiveID(String value) {
        PreferenceUI.getPreferenceStore().setValue("switch_perspective_id", value);
    }

    public static boolean isBIDIVisualEditing() {
        return PreferenceUI.getPreferenceStore().getBoolean("enable_bidi_visual_editing");
    }

    public static boolean isBIDIArabicShaping() {
        return PreferenceUI.getPreferenceStore().getBoolean("enable_bidi_arabic_shaping");
    }

    public static boolean isDisplayValues() {
        return PreferenceUI.getPreferenceStore().getBoolean("display_values_on_array_structs");
    }

    public static boolean isIncludeStackEntries() {
        return PreferenceUI.getPreferenceStore().getBoolean("include_stack_entries");
    }

    public static boolean isDebugInfoFilter() {
        return PreferenceUI.getPreferenceStore().getBoolean("debug_info_filter");
    }

    public static void setDebugInfoFilter(boolean setting) {
        PreferenceUI.getPreferenceStore().setValue("debug_info_filter", setting);
    }

    public static int getForkSetting() {
        return PreferenceUI.getPreferenceStore().getInt("pref_remember_fork");
    }

    public static boolean isBrkptSuspendAllThreads() {
        return PreferenceUI.getPreferenceStore().getBoolean("syncStop");
    }

    public static boolean isLocalsSort() {
        return PreferenceUI.getPreferenceStore().getBoolean("locals_sort");
    }

    public static void setLocalsSort(boolean setting) {
        PreferenceUI.getPreferenceStore().setValue("locals_sort", setting);
    }

    public static void setHideRunningThreads(boolean setting) {
        PreferenceUI.getPreferenceStore().setValue("hide_running_threads", setting);
    }

    public static boolean isHideRunningThreads() {
        return PreferenceUI.getPreferenceStore().getBoolean("hide_running_threads");
    }

    public static boolean isHiddenMessage(String msg) {
        String savedMsg;
        String messageID = EPDCUtils.getValidMessageID((String)msg);
        if (messageID.isEmpty()) {
            messageID = msg;
        }
        return !(savedMsg = PreferenceUI.getPreferenceStore().getString("hidden_msg." + messageID)).isEmpty();
    }

    public static void setHiddenMessage(String msg) {
        String messageID = EPDCUtils.getValidMessageID((String)msg);
        if (messageID.isEmpty()) {
            messageID = msg;
        }
        PreferenceUI.getPreferenceStore().setValue("hidden_msg." + messageID, msg);
    }

    public static int getMonitorViewSashWeight1() {
        return PreferenceUI.getPreferenceStore().getInt("monitor_view_sashweight_1");
    }

    public static int getMonitorViewSashWeight2() {
        return PreferenceUI.getPreferenceStore().getInt("monitor_view_sashweight_2");
    }

    public static boolean getMonitorViewShowDetailPane() {
        return PreferenceUI.getPreferenceStore().getBoolean("monitor_view_show_detailpane");
    }

    public static int getMonitorExpandDepth() {
        return PreferenceUI.getPreferenceStore().getInt("monitor_view_expand_depth");
    }

    public static boolean getMonitorMemoryMode() {
        return PreferenceUI.getPreferenceStore().getBoolean("monitor_view_rendering_mode");
    }

    public static void setMonitorViewSashWeight1(int sashWeight) {
        PreferenceUI.getPreferenceStore().setValue("monitor_view_sashweight_1", sashWeight);
    }

    public static void setMonitorViewSashWeight2(int sashWeight) {
        PreferenceUI.getPreferenceStore().setValue("monitor_view_sashweight_2", sashWeight);
    }

    public static void setMonitorViewShowDetailPane(boolean show) {
        PreferenceUI.getPreferenceStore().setValue("monitor_view_show_detailpane", show);
    }

    public static void setMonitorMemoryMode(boolean show) {
        PreferenceUI.getPreferenceStore().setValue("monitor_view_rendering_mode", show);
    }

    public static void setMonitorExpandDepth(int depth) {
        PreferenceUI.getPreferenceStore().setValue("monitor_view_expand_depth", depth);
    }

    public static String getDefaultRenderingId() {
        return PreferenceUI.getPreferenceStore().getString("defaultRendering");
    }

    public static void setDefaultRenderingId(String rendering) {
        PreferenceUI.getPreferenceStore().setValue("defaultRendering", rendering);
    }

    public static int getHoverSashWeight1() {
        return PreferenceUI.getPreferenceStore().getInt("hover_sashweight_1");
    }

    public static int getHoverSashWeight2() {
        return PreferenceUI.getPreferenceStore().getInt("hover_sashweight_2");
    }

    public static void setHoverSashWeight1(int sashWeight) {
        PreferenceUI.getPreferenceStore().setValue("hover_sashweight_1", sashWeight);
    }

    public static void setHoverSashWeight2(int sashWeight) {
        PreferenceUI.getPreferenceStore().setValue("hover_sashweight_2", sashWeight);
    }
}

