/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.preferences;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.DefaultBIDIEngine;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.CommunicationPrefFields;
import com.ibm.debug.pdt.internal.ui.dialogs.DeleteProfileDialog;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUIConstants;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class PDTPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private boolean fSupportsPerspectiveSwitchPref;
    private HashMap<String, String> fPerspectiveIDs;
    private Combo fPerspectivesCombo;

    public PDTPreferencePage() {
        super(1);
        if (PreferenceUIConstants.SHOW_SWITCHPERSPECTIVEIDPREF && this.isStandaloneProduct()) {
            this.fSupportsPerspectiveSwitchPref = true;
        }
    }

    private boolean isStandaloneProduct() {
        String runningProductId = Platform.getProduct().getId();
        return runningProductId.startsWith("com.ibm.debug");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), PICLUtils.getHelpResourceString("preference_page"));
        Dialog.applyDialogFont((Control)this.getControl());
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)PreferenceUI.getPreferenceStore());
    }

    public void createFieldEditors() {
        if (PreferenceUIConstants.SHOW_DISPLAYVALUESPREF) {
            this.addField((FieldEditor)new BooleanFieldEditor("display_values_on_array_structs", PICLLabels.PICLDebugPreferencePage_DisplayArrayLabel, this.getFieldEditorParent()));
        }
        Composite comp = this.getFieldEditorParent();
        if (PreferenceUIConstants.SHOW_DELETEPROGRAMPROFILESPREF) {
            new Label(comp, 0).setText(PICLLabels.PICLDebugPreferencePage_DeleteProgramProfiles);
            Composite profileComp = new Composite(comp, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            profileComp.setLayout((Layout)layout);
            Button b = new Button(profileComp, 0);
            b.setText(PICLLabels.PICLDebugPreferencePage_DeleteAllProgramProfilesButton);
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openConfirm((Shell)PDTPreferencePage.this.getShell(), (String)PICLLabels.PICLDebugPreferencePage_ConfirmationToDeleteAllProfiles, (String)PICLLabels.PICLDebugPreferencePage_ConfirmationToDeleteAllProfiles)) {
                        PDTCoreUtils.deleteDebuggerPersistentProfiles();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            b = new Button(profileComp, 0);
            b.setText(PICLLabels.PICLDebugPreferencePage_DeleteSelectProgramProfilesButton);
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    new DeleteProfileDialog(PDTPreferencePage.this.getShell()).open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (PreferenceUIConstants.SHOW_SAVEEXCEPTIONSBYPROFILEPREF) {
            this.addField((FieldEditor)new BooleanFieldEditor("save_exceptions_by_profile", PICLLabels.PICLDebugPreferencePage_SaveEventsByProfile, 0, comp));
        }
        if (PreferenceUIConstants.SHOW_GLOBAL_SEARCH_PATH) {
            this.addField((FieldEditor)new StringFieldEditor("global_engine_path", PICLLabels.GlobalEnginePath, this.getFieldEditorParent()));
        }
        if (PreferenceUIConstants.SHOW_TRACEOPTIONSPREF) {
            this.addField(new CommunicationPrefFields(comp));
        }
        if (PreferenceUIConstants.SHOW_RESETHIDDENMESSAGESPREF) {
            new Label(comp, 0).setText(PICLLabels.PICLDebugPreferencePage_SuppressedMessages);
            Button resetButton = new Button(comp, 0);
            resetButton.setText(PICLLabels.PICLDebugPreferencePage_SuppressedMessages_Button);
            resetButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IEclipsePreferences node = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.ui");
                    node.remove("pref_remember_fork");
                    try {
                        String[] stringArray = node.keys();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            if (key.startsWith("hidden_msg.")) {
                                node.remove(key);
                            }
                            ++n2;
                        }
                    }
                    catch (BackingStoreException e1) {
                        PICLUtils.logError((Exception)((Object)e1));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.fSupportsPerspectiveSwitchPref) {
            IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
            String[] fPerspectiveLabels = new String[descriptors.length + 1];
            fPerspectiveLabels[0] = PICLLabels.PICLDebugPreferencePage_perspectiveNone;
            this.fPerspectiveIDs = new HashMap(descriptors.length);
            this.fPerspectiveIDs.put(PICLLabels.PICLDebugPreferencePage_perspectiveNone, "perspective_none");
            int i = 0;
            while (i < descriptors.length) {
                IPerspectiveDescriptor descriptor = descriptors[i];
                fPerspectiveLabels[i + 1] = descriptor.getLabel();
                this.fPerspectiveIDs.put(descriptor.getLabel(), descriptor.getId());
                ++i;
            }
            Group perspectiveGroup = new Group(comp, 0);
            perspectiveGroup.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            perspectiveGroup.setLayoutData((Object)gd);
            Label label = new Label((Composite)perspectiveGroup, 0);
            label.setText(PICLLabels.PICLDebugPreferencePage_perspectiveLabel);
            this.fPerspectivesCombo = new Combo((Composite)perspectiveGroup, 8);
            this.fPerspectivesCombo.setFont(perspectiveGroup.getFont());
            this.fPerspectivesCombo.setItems(fPerspectiveLabels);
            String perspectiveID = PreferenceUI.getSwitchPerspectiveID();
            IPerspectiveDescriptor descriptor = null;
            if (perspectiveID != null) {
                descriptor = registry.findPerspectiveWithId(perspectiveID);
            }
            if (descriptor == null) {
                this.fPerspectivesCombo.setText(PICLLabels.PICLDebugPreferencePage_perspectiveNone);
            } else {
                this.fPerspectivesCombo.setText(descriptor.getLabel());
            }
        }
        if (PreferenceUIConstants.SHOW_ENABLEBIDIVISUALEDITORSPREF && !(PDTCorePlugin.getBIDIEngine() instanceof DefaultBIDIEngine)) {
            Group bidiGroup = new Group(comp, 0);
            bidiGroup.setLayout((Layout)new GridLayout());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            bidiGroup.setLayoutData((Object)gd);
            bidiGroup.setText(PICLLabels.PICLDebugPreferencePage_BIDIGroup);
            this.addField((FieldEditor)new BooleanFieldEditor("enable_bidi_visual_editing", PICLLabels.PICLDebugPreferencePage_enableBIDIVisualEditorsLabel, (Composite)bidiGroup));
            this.addField((FieldEditor)new BooleanFieldEditor("enable_bidi_arabic_shaping", PICLLabels.PICLDebugPreferencePage_enableBIDIArabicShapingLabel, (Composite)bidiGroup));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean rc = super.performOk();
        if (this.fSupportsPerspectiveSwitchPref) {
            String perspectiveLabel = this.fPerspectivesCombo.getText();
            String perspectiveID = this.fPerspectiveIDs.get(perspectiveLabel);
            InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.ui").put("switch_perspective_id", perspectiveID);
        }
        return rc;
    }

    protected void performDefaults() {
        if (this.fSupportsPerspectiveSwitchPref) {
            String perspectiveDefaultID = DefaultScope.INSTANCE.getNode("com.ibm.debug.pdt.ui").get("switch_perspective_id", "org.eclipse.debug.ui.DebugPerspective");
            IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor descriptor = null;
            if (perspectiveDefaultID != null) {
                descriptor = registry.findPerspectiveWithId(perspectiveDefaultID);
            }
            if (descriptor == null) {
                this.fPerspectivesCombo.setText(PICLLabels.PICLDebugPreferencePage_perspectiveNone);
            } else {
                this.fPerspectivesCombo.setText(descriptor.getLabel());
            }
        }
        super.performDefaults();
    }
}

