/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Address;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Memory;
import com.ibm.debug.pdt.internal.core.model.MemoryException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.memory.ITextRenderingRepAdvisor;
import com.ibm.debug.pdt.internal.ui.memory.PICLExtendedMemoryBlockRetrieval;
import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;

public class PICLMemoryBlock
extends PlatformObject
implements IMemoryBlockExtension {
    private String fExpression;
    private DebuggeeThread fThreadContext;
    private PDTDebugTarget fDebugTarget;
    private DebuggeeProcess fProcess;
    private Location fLocation;
    private PICLExtendedMemoryBlockRetrieval fMemoryBlockRetrieval;
    private boolean fSupportsStorageModification;
    private boolean fExpressionIsAddress;
    private int fRequestedMemLen = 0;
    private String fPartition;
    private BigInteger fBaseAddress = null;
    private int fAddressSize = -1;
    private boolean fEnabled = true;
    private int fHashCode;

    public PICLMemoryBlock() {
    }

    public PICLMemoryBlock(String expression, DebuggeeThread threadContext, Location location) throws DebugException {
        this.fExpression = expression;
        this.fThreadContext = threadContext;
        this.fDebugTarget = (PDTDebugTarget)threadContext.getDebugTarget();
        this.fLocation = location;
        this.fMemoryBlockRetrieval = (PICLExtendedMemoryBlockRetrieval)((Object)this.fDebugTarget.getAdapter(IMemoryBlockRetrieval.class));
        this.fProcess = (DebuggeeProcess)this.fDebugTarget.getProcess();
        this.getBigBaseAddress();
        if (this.fBaseAddress == null) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_unable_convert_to_address, null);
            throw new DebugException((IStatus)status);
        }
        this.fExpressionIsAddress = this.isExpressionAddress();
        this.fSupportsStorageModification = true;
    }

    protected final void finalize() {
    }

    private boolean isExpressionAddress() {
        if (this.fExpression != null && PDTCoreUtils.isAddress((String)this.fExpression)) {
            if (this.fExpression.startsWith("0x") || this.fExpression.startsWith("0X")) {
                return this.fBaseAddress.equals(new BigInteger(this.fExpression.substring(2), 16));
            }
            return this.fBaseAddress.equals(new BigInteger(this.fExpression, 16));
        }
        return false;
    }

    PICLMemoryBlock(PDTDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
        this.fProcess = (DebuggeeProcess)this.fDebugTarget.getProcess();
    }

    public DebuggeeThread getThreadContext() {
        return this.fThreadContext;
    }

    public Location getLocation() {
        return this.fLocation;
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        Address value;
        if (this.fBaseAddress != null) {
            return this.fBaseAddress;
        }
        try {
            value = this.getAddressFromExpression();
        }
        catch (MemoryException e) {
            throw new DebugException((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), 5012, e.getMessage(), null));
        }
        if (value == null) {
            return null;
        }
        try {
            this.fBaseAddress = new BigInteger(value.getAddress(), 16);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return this.fBaseAddress;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    public boolean supportBaseAddressModification() {
        return true;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
        this.fBaseAddress = address;
    }

    public MemoryByte[] getBytesFromOffset(long offset, long length) throws DebugException {
        if (this.fBaseAddress == null) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_base_address_not_set, null);
            throw new DebugException((IStatus)status);
        }
        if (length > Integer.MAX_VALUE) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_length_request_not_supported, null);
            throw new DebugException((IStatus)status);
        }
        BigInteger newAddr = this.fBaseAddress.add(BigInteger.valueOf(offset));
        return this.getBytesFromAddress(newAddr, length);
    }

    public void enable() {
        this.fEnabled = true;
        this.fBaseAddress = null;
    }

    public void disable() {
        this.fEnabled = false;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void delete() {
        if (this.fMemoryBlockRetrieval != null) {
            this.fMemoryBlockRetrieval.removeMemoryBlock(this);
        }
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.fMemoryBlockRetrieval;
    }

    public long getStartAddress() {
        if (this.fBaseAddress != null) {
            return this.fBaseAddress.longValue();
        }
        try {
            this.fBaseAddress = this.getBigBaseAddress();
            if (this.fBaseAddress != null) {
                return this.fBaseAddress.longValue();
            }
            return 0L;
        }
        catch (DebugException e) {
            return 0L;
        }
    }

    public long getLength() {
        return this.fRequestedMemLen;
    }

    public byte[] getBytes() throws DebugException {
        if (this.fBaseAddress == null) {
            return null;
        }
        MemoryByte[] memory = this.getBytesFromAddress(this.fBaseAddress, this.fRequestedMemLen);
        byte[] mem = new byte[this.fRequestedMemLen];
        int i = 0;
        while (i < this.fRequestedMemLen) {
            mem[i] = memory[i].getValue();
            ++i;
        }
        return mem;
    }

    public boolean supportsValueModification() {
        return this.fSupportsStorageModification;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public String getModelIdentifier() {
        return this.fDebugTarget.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.fDebugTarget.getLaunch();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMemoryBlockRetrieval.class || adapter == IMemoryBlockRetrievalExtension.class) {
            return this.fMemoryBlockRetrieval;
        }
        if (adapter == ITextRenderingRepAdvisor.class) {
            final DebugEngine engine = this.fDebugTarget.getDebugEngine();
            return new ITextRenderingRepAdvisor(){

                @Override
                public int getDefaultRepresentation() {
                    return engine.getDefaultMemoryRep();
                }

                @Override
                public void setDefaultRepresentation(int representation) {
                    engine.setDefaultMemoryRep(representation);
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private Address getAddressFromExpression() throws MemoryException {
        if (this.fThreadContext == null || this.fDebugTarget == null || this.fLocation == null || this.fDebugTarget.isTerminated()) {
            return null;
        }
        Address address = null;
        if (this.fDebugTarget.supportsEnhancedStorage()) {
            address = this.fProcess.convertToAddress(this.fExpression, this.fLocation, this.fThreadContext);
            this.fPartition = address.getPartition();
        } else {
            Memory mem = this.fProcess.getMemory(this.fExpression, 16, this.fLocation, this.fThreadContext, 0);
            if (mem != null) {
                address = new Address(mem.getBaseAddress(), mem.getAddressSize());
            }
        }
        if (address != null) {
            this.fAddressSize = address.getAddressSize();
        }
        return address;
    }

    public void setMemLength(long length) {
        this.fRequestedMemLen = (int)length;
    }

    public void setLocation(Location loc) {
        this.fLocation = loc;
    }

    public void memoryChanged(boolean fireEvent) {
        if (this.fExpressionIsAddress) {
            return;
        }
        this.fBaseAddress = null;
        if (fireEvent) {
            this.fireChangedEvent();
        }
    }

    private void fireChangedEvent() {
        DebugEvent evnt = new DebugEvent((Object)this, 16, 512);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{evnt});
    }

    public boolean isMemoryChangesManaged() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PICLMemoryBlock) {
            PICLMemoryBlock mem = (PICLMemoryBlock)((Object)obj);
            try {
                if (mem.getExpression().equals(this.fExpression) && mem.getLocation().equals((Object)this.fLocation) && mem.getThreadContext().equals(this.fThreadContext)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = 17;
            this.fHashCode = 37 * this.fHashCode + (this.fExpression == null ? 0 : this.fExpression.hashCode());
            this.fHashCode = 37 * this.fHashCode + (this.fLocation == null ? 0 : this.fLocation.hashCode());
            this.fHashCode = 37 * this.fHashCode + (this.fThreadContext == null ? 0 : this.fThreadContext.hashCode());
        }
        return this.fHashCode;
    }

    public String getExpression() {
        return this.fExpression;
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        return null;
    }

    public boolean supportsChangeManagement() {
        return false;
    }

    public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
        return null;
    }

    public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
        Memory mem;
        Object addr;
        int offset;
        if (units > Integer.MAX_VALUE) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_length_request_not_supported, null);
            throw new DebugException((IStatus)status);
        }
        if (address == null) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_invalid_address, null);
            throw new DebugException((IStatus)status);
        }
        if (this.fDebugTarget.supportsEnhancedStorage()) {
            Object addr2 = address.toString(16);
            if (PDTDebugUtils.isDebugToolEngine((IDebugTarget)this.fDebugTarget)) {
                try {
                    addr2 = this.fProcess.convertToAddress((String)addr2, this.fLocation, this.fThreadContext).getAddress();
                }
                catch (MemoryException memoryException) {
                    // empty catch block
                }
            }
            try {
                if (this.fPartition != null) {
                    addr2 = this.fPartition + ":" + (String)addr2;
                }
                Memory mem2 = this.fProcess.getMemory((String)addr2, (int)units);
                return mem2.getMemory();
            }
            catch (MemoryException e) {
                throw new DebugException((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), 5012, e.getMessage(), (Throwable)e));
            }
        }
        if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)this.fDebugTarget)) {
            offset = address.subtract(this.fBaseAddress).intValue();
            addr = this.fExpression;
        } else {
            offset = 0;
            addr = "0x" + address.toString(16);
        }
        try {
            mem = this.fProcess.getMemory((String)addr, (int)units, this.fLocation, this.fThreadContext, offset);
        }
        catch (MemoryException e) {
            throw new DebugException((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), 5012, e.getMessage(), (Throwable)e));
        }
        if (mem == null) {
            throw new DebugException((IStatus)new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_unable_to_retrieve_memory, null));
        }
        return mem.getMemory();
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        BigInteger tmpAddr = this.fBaseAddress.add(offset);
        Object writeAddress = tmpAddr.toString(16);
        try {
            IPDTDebugTracer[] tracerClasses;
            IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = this.fDebugTarget.getDebugTracers();
            int n = tracerClasses.length;
            int n2 = 0;
            while (n2 < n) {
                IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                String[] extraInfo = new String[]{this.getExpression(), writeAddress};
                tracerClass.traceUserAction((Object)bytes, (short)3, extraInfo);
                ++n2;
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
        if (this.fDebugTarget.supportsEnhancedStorage()) {
            try {
                if (this.fPartition != null) {
                    writeAddress = this.fPartition + ":" + (String)writeAddress;
                }
                this.fProcess.putMemory((String)writeAddress, bytes);
            }
            catch (MemoryException e) {
                Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, e.getMessage(), (Throwable)e);
                throw new DebugException((IStatus)status);
            }
        }
        Memory memToWrite = new Memory(bytes);
        try {
            this.fProcess.putMemory((String)writeAddress, memToWrite, this.getExpression());
        }
        catch (MemoryException e) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, e.getMessage(), null);
            throw new DebugException((IStatus)status);
        }
        this.fireChangedEvent();
    }

    public void connect(Object client) {
    }

    public void disconnect(Object client) {
    }

    public Object[] getConnections() {
        return new Object[0];
    }

    public void dispose() throws DebugException {
        this.delete();
    }

    public int getAddressableSize() throws DebugException {
        return 1;
    }

    public String getPartition() {
        return this.fPartition;
    }
}

