/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLRegister;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.memory.MapStorageAction;
import com.ibm.debug.pdt.internal.ui.memory.MonitorMemoryMenuManager;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MapStorageActionDelegate
implements IObjectActionDelegate {
    private PDTDebugElement fCurrentElement;
    private IAction fAction;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (!(targetPart instanceof AbstractDebugView)) return;
        IMenuManager menuManager = null;
        AbstractDebugView adv = (AbstractDebugView)targetPart;
        List managers = adv.getContextMenuManagers();
        if (managers != null && !managers.isEmpty()) {
            Iterator iter = managers.iterator();
            while (iter.hasNext() && menuManager == null) {
                menuManager = ((IMenuManager)iter.next()).findMenuUsingPath("com.ibm.debug.pdt.ui.actions.mapstorage.menu");
            }
        }
        if (menuManager == null) {
            return;
        }
        boolean singleSelection = true;
        ISelection selection = adv.getViewSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (!(sel instanceof PICLRegister) && !(sel instanceof ExprNodeBase)) return;
            this.fCurrentElement = (PDTDebugElement)sel;
        } else {
            singleSelection = false;
        }
        if (this.fCurrentElement == null) {
            return;
        }
        PDTDebugTarget tgt = PICLDebugPlugin.getPDTDebugTarget(selection);
        if (tgt == null || tgt.isTerminated()) {
            return;
        }
        MonitorMemoryMenuManager storageMenuMan = new MonitorMemoryMenuManager(this.fCurrentElement);
        MapStorageAction[] storageActions = storageMenuMan.getActions();
        if (storageActions.length <= 0) return;
        if (storageActions[0] != null) {
            this.fAction = storageActions[0];
            action.setText(this.fAction.getText());
        }
        int i = 1;
        while (i < storageActions.length) {
            storageActions[i].setEnabled(singleSelection);
            menuManager.add((IAction)storageActions[i]);
            ++i;
        }
    }

    public void run(IAction action) {
        if (this.fAction != null) {
            this.fAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

