/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DerefMemBlkActionDelegate
implements IObjectActionDelegate {
    private IRepositionableMemoryRendering fRendering;

    public void run(IAction action) {
        if (this.fRendering == null) {
            return;
        }
        IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
        BigInteger addr = this.fRendering.getSelectedAddress();
        if (memoryBlock instanceof IMemoryBlockExtension && addr != null) {
            MemoryByte[] byteArray;
            try {
                IMemoryBlockExtension mbext = (IMemoryBlockExtension)memoryBlock;
                byteArray = mbext.getBytesFromAddress(addr, (long)mbext.getAddressSize());
            }
            catch (DebugException e) {
                ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)PICLLabels.ErrorDialog_error, null, (IStatus)e.getStatus());
                return;
            }
            if (byteArray == null || byteArray.length == 0) {
                return;
            }
            byte[] bytes = new byte[byteArray.length];
            int i = 0;
            while (i < byteArray.length) {
                if (!byteArray[i].isReadable()) {
                    Status status = new Status(4, PICLDebugPlugin.getPluginID(), 0, PICLMessages.picl_memory_error_unable_convert_to_address, null);
                    ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)PICLLabels.ErrorDialog_error, null, (IStatus)status);
                    return;
                }
                bytes[i] = byteArray[i].getValue();
                ++i;
            }
            boolean bigEndian = byteArray[0].isBigEndian();
            BigInteger gotoAddress = DerefMemBlkActionDelegate.convertByteArrayToBigInteger(bytes, bigEndian);
            try {
                this.fRendering.goToAddress(gotoAddress);
            }
            catch (DebugException e) {
                ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)PICLLabels.ErrorDialog_error, null, (IStatus)e.getStatus());
                return;
            }
        }
    }

    public static BigInteger convertByteArrayToBigInteger(byte[] array, boolean bigEndian) {
        if (array.length < 16) {
            array = DerefMemBlkActionDelegate.fillArray(array, 16, bigEndian);
        }
        if (!bigEndian) {
            byte[] holder = new byte[16];
            int j = 15;
            int i = 0;
            while (i < 16) {
                holder[i] = array[j];
                ++i;
                --j;
            }
            BigInteger value = new BigInteger(holder);
            return value;
        }
        BigInteger value = new BigInteger(array);
        return value;
    }

    protected static byte[] fillArray(byte[] array, int size, boolean bigEndian) {
        if (!bigEndian) {
            byte[] temp = new byte[size];
            int i = 0;
            while (i < array.length) {
                temp[i] = array[i];
                ++i;
            }
            i = array.length;
            while (i < size) {
                temp[i] = 0;
                ++i;
            }
            array = temp;
            return array;
        }
        byte[] temp = new byte[size];
        int i = 0;
        while (i < size - array.length) {
            temp[i] = 0;
            ++i;
        }
        int j = 0;
        int i2 = size - array.length;
        while (i2 < size) {
            temp[i2] = array[j];
            ++j;
            ++i2;
        }
        array = temp;
        return array;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IRepositionableMemoryRendering) {
            this.fRendering = (IRepositionableMemoryRendering)obj;
            return;
        }
        this.fRendering = null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

