/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.editor;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.internal.core.AbstractEditorFile;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.IModuleEventListener;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.ModuleUnloadedEvent;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.PartAddedEvent;
import com.ibm.debug.pdt.internal.core.model.PartDeletedEvent;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.FilePrintAction;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditorContextContributor;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerParser;
import com.ibm.debug.pdt.internal.ui.editor.PDTSourceViewerConfiguration;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.ui.DebugEditorActionContributor;
import com.ibm.debug.pdt.ui.DebuggerMarkerAnnotationModel;
import com.ibm.lpex.alef.LpexTextEditor;
import com.ibm.lpex.alef.preferences.ViewParserPreferencePage;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexViewListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DebuggerEditor
extends LpexTextEditor
implements IDebugEventSetListener,
IModuleEventListener,
IElementStateListener,
IPropertyChangeListener,
IDebugContextListener,
EventHandler {
    private static String fFont = null;
    private DebugEditorActionContributor dbgEd;
    private boolean fCenterOnExecutionLine;
    private RGB fExecutionLineColour;
    private int fCurrentExecutionLine;
    private IAction fDefaultLPEXFindTextAction;
    private IAction fDefaultLPEXFindNextAction;
    private IAction fDefaultLPEXFindPrevAction;
    private Module fModule = null;
    private Part fPart = null;
    private LpexViewAdapter fViewListener = new LpexViewAdapter(){
        int fRows = 0;

        public void shown(LpexView lpexView) {
            LpexDocumentLocation location = lpexView.documentLocation();
            int numRows = lpexView.queryInt("rows");
            boolean isCommandAreaVisible = lpexView.window().commandLine().isVisible();
            if (numRows != this.fRows && numRows > 0 && !isCommandAreaVisible) {
                ViewFile viewFile;
                IEditorInput editorInput = DebuggerEditor.this.getEditorInput();
                if (editorInput instanceof EngineSuppliedViewEditorInput && (viewFile = ((EngineSuppliedViewEditorInput)editorInput).getViewFile()).isDynamic()) {
                    ((EngineSuppliedViewEditorInput)editorInput).setDynamicBufferSize(numRows + 2);
                    if (numRows > this.fRows && this.fRows != 0) {
                        try {
                            ((EngineSuppliedViewEditorInput)editorInput).ensureRange(lpexView.queryInt("line"));
                            lpexView.jump(location);
                        }
                        catch (DebugException e) {
                            PICLUtils.logError((Exception)((Object)e));
                        }
                    }
                }
                this.fRows = numRows;
            }
        }

        public void disposed(LpexView lpexView) {
            lpexView.removeLpexViewListener((LpexViewListener)this);
        }
    };

    public DebuggerEditor() {
        this.dbgEd = new DebugEditorActionContributor();
        this.setEditorContextMenuId("#com.ibm.debug.pdt.debuggereditor.TextEditorContext");
        this.setRulerContextMenuId("#com.ibm.debug.pdt.debuggereditor.TextRulerContext");
        this.setDocumentProvider((IDocumentProvider)PICLDebugPlugin.getInstance().getDebuggerEditorDocumentProvider());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new PDTSourceViewerConfiguration((ITextEditor)this));
        this.setHelpContextId(PICLUtils.getHelpResourceString("debugger_editor"));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), "Invalid editor input");
            throw new PartInitException((IStatus)status);
        }
        if (((EngineSuppliedViewEditorInput)input).isCurrentlyDisplayed()) {
            Status status = new Status(1, PICLDebugPlugin.getPluginID(), PICLMessages.FeatureNotSupported);
            throw new PartInitException((IStatus)status);
        }
        super.init(site, input);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
        PICLDebugPlugin.getInstance().getDebuggerEditorDocumentProvider().addElementStateListener(this);
        this.fCenterOnExecutionLine = PreferenceUI.isCenterOnExecution();
        this.fExecutionLineColour = PreferenceUI.getExecutionLineColor();
        PreferenceUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
        IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (eventBroker != null) {
            eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/themeChanged", (EventHandler)this);
            eventBroker.subscribe("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", (EventHandler)this);
            eventBroker.subscribe("org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryModified", (EventHandler)this);
        }
    }

    public void dispose() {
        IEditorInput input;
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (eventBroker != null) {
            eventBroker.unsubscribe((EventHandler)this);
        }
        if ((input = this.getEditorInput()) == null) {
            super.dispose();
            return;
        }
        if (input instanceof EngineSuppliedViewEditorInput) {
            if (this.fModule != null) {
                this.fModule.removeListener((IModelEventListener)this);
                this.fModule = null;
                this.fPart = null;
            }
            ((EngineSuppliedViewEditorInput)input).setCurrentlyDisplayed(false);
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugContextManager.getDefault().removeDebugContextListener((IDebugContextListener)this);
        PICLDebugPlugin.getInstance().getDebuggerEditorDocumentProvider().removeElementStateListener(this);
        PreferenceUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public Location findNext() {
        return this.findString("", false, true);
    }

    public Location findString(String expression, boolean caseSensitive, boolean findNext) {
        IAction findNextAction;
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)this, "DebuggerEditor: trying to use debug Find Text dialog on a non-EngineSuppliedView");
            }
            return null;
        }
        EngineSuppliedViewEditorInput esv = (EngineSuppliedViewEditorInput)input;
        ViewFile viewFile = esv.getViewFile();
        Location stringLocation = null;
        int startLineNumber = 0;
        int startLineOffset = 0;
        LpexView lpexView = this.getLpexView();
        startLineNumber = PICLUtils.getRealLineNumber((IEditorInput)esv, lpexView.lineOfElement(lpexView.currentElement()));
        startLineOffset = lpexView.currentPosition() - esv.getPrefixLength();
        if (startLineOffset <= 0) {
            startLineOffset = 1;
        }
        stringLocation = findNext ? viewFile.findNext() : viewFile.findString(expression, startLineNumber, startLineOffset, caseSensitive);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof DebuggerEditorContextContributor) {
            ((DebuggerEditorContextContributor)contributor).updateActions();
        }
        if ((findNextAction = this.getAction("FindNextMenuAction")) instanceof IUpdate) {
            ((IUpdate)findNextAction).update();
        }
        return stringLocation;
    }

    public void selectAndReveal(int offset, int length) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int originalLineNumber = 0;
        try {
            originalLineNumber = doc.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.gotoLine(++originalLineNumber, true);
    }

    public void gotoLine(int lineNumber, boolean highlight) {
        int element;
        if (lineNumber <= 0) {
            return;
        }
        LpexView lpexView = this.getLpexView();
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof EngineSuppliedViewEditorInput) {
            try {
                ((EngineSuppliedViewEditorInput)editorInput).ensureRange(lineNumber);
            }
            catch (Exception de) {
                PICLUtils.logError(de);
                return;
            }
            lineNumber = PICLUtils.getBufferedLineNumber(editorInput, lineNumber);
        }
        if ((element = lpexView.elementOfLine(lineNumber)) <= 0) {
            return;
        }
        LpexDocumentLocation loc = new LpexDocumentLocation(element, 1);
        if (lpexView.query("includedClasses").length() != 0) {
            lpexView.doCommand("set includedClasses");
        }
        if (highlight) {
            this.hiliteLine(lpexView, loc);
        }
        lpexView.jump(loc);
        lpexView.doCommand("screenShow document");
        if (this.fCenterOnExecutionLine) {
            lpexView.triggerAction(lpexView.actionId("scrollCenter"));
        }
    }

    public void gotoMarker(IMarker marker) {
        int lineNumber = -1;
        IBreakpointManager bpManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint iBP = bpManager.getBreakpoint(marker);
        if (iBP instanceof PICLLocationBreakpoint) {
            Location bpLocation = null;
            try {
                PICLLocationBreakpoint piclLocationBP = (PICLLocationBreakpoint)iBP;
                ViewInformation bpViewInfo = piclLocationBP.getViewInformation();
                bpLocation = piclLocationBP.getLocation(bpViewInfo);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (bpLocation != null) {
                lineNumber = bpLocation.getLineNumber();
            }
        } else {
            lineNumber = marker.getAttribute("lineNumber", 1);
        }
        this.gotoLine(lineNumber, false);
    }

    public boolean isEditable() {
        if (this.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            return false;
        }
        return super.isEditable();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        LpexView lpexView = this.getLpexView();
        if (lpexView == null) {
            return;
        }
        lpexView.doCommand("set updateProfile.parserClass.debuggerParser com.ibm.debug.pdt.internal.ui.editor.DebuggerParser");
        lpexView.doCommand("set updateProfile.parser debuggerParser");
        lpexView.doCommand("updateProfile");
        lpexView.doDefaultCommand("set scrollWhileAdjusting off");
        LpexParser parser = lpexView.parser();
        if (parser instanceof DebuggerParser) {
            ((DebuggerParser)parser).setEditor((ITextEditor)this);
            IEditorInput input = this.getEditorInput();
            if (input instanceof EngineSuppliedViewEditorInput) {
                EngineSuppliedViewEditorInput engineInput = (EngineSuppliedViewEditorInput)input;
                try {
                    this.setDocumentSection((AbstractEditorFile)engineInput.getStorage());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    protected IPreferencePage createViewPreferencePage(LpexView lpexView, int prefNodeType) {
        if (prefNodeType == 1 && this.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            return new DebuggerViewParserPreferencePage(lpexView);
        }
        return super.createViewPreferencePage(lpexView, prefNodeType);
    }

    public static boolean isDarkTheme() {
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        IEclipseContext context = application.getContext();
        IThemeEngine engine = (IThemeEngine)context.get(IThemeEngine.class);
        ITheme theme = engine.getActiveTheme();
        return theme != null && theme.getId().equals("org.eclipse.e4.ui.css.theme.e4_dark");
    }

    public static boolean isHighContrastTheme() {
        MApplication application = (MApplication)PlatformUI.getWorkbench().getService(MApplication.class);
        IEclipseContext context = application.getContext();
        IThemeEngine engine = (IThemeEngine)context.get(IThemeEngine.class);
        ITheme theme = engine.getActiveTheme();
        return theme != null && theme.getId().equals("org.eclipse.e4.ui.css.theme.high-contrast");
    }

    public void updateProfile(LpexView lpexView) {
        this.initializeKeyBindingScopes();
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.setPartName(this.getEditorInput().getName());
            this.setAction("RulerDoubleClick", this.getAction("BreakpointRulerAction"));
            if (this.fDefaultLPEXFindTextAction != null) {
                this.fDefaultLPEXFindTextAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
                this.setAction(ITextEditorActionConstants.FIND, this.fDefaultLPEXFindTextAction);
            }
            if (this.fDefaultLPEXFindNextAction != null) {
                this.fDefaultLPEXFindNextAction.setActionDefinitionId("org.eclipse.ui.edit.findNext");
                this.setAction("org.eclipse.ui.edit.findNext", this.fDefaultLPEXFindNextAction);
            }
            if (this.fDefaultLPEXFindPrevAction != null) {
                this.fDefaultLPEXFindPrevAction.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
                this.setAction("org.eclipse.ui.edit.findPrevious", this.fDefaultLPEXFindPrevAction);
            }
        } else if (input instanceof EngineSuppliedViewEditorInput) {
            this.setPartName(this.getEditorInput().getName());
            EngineSuppliedViewEditorInput dei = (EngineSuppliedViewEditorInput)input;
            LpexParser parser = lpexView.parser();
            if (parser instanceof DebuggerParser) {
                ((DebuggerParser)parser).setEditor((ITextEditor)this);
                lpexView.doCommand("parse all");
            }
            PICLDebugTarget dbgtgt = dei.getPICLDebugTarget();
            int prefixLength = dei.getPrefixLength();
            if (dbgtgt != null && !dbgtgt.isTerminated() && PDTDebugUtils.isiSeriesEngine((IDebugTarget)dbgtgt) && this.hasISeriesSequenceNumbers(prefixLength)) {
                lpexView.doCommand("set sequenceNumbers " + String.valueOf(prefixLength + 1) + " 6 " + String.valueOf(prefixLength + 1 + 6) + " 6");
                lpexView.doCommand("set prefixAreaText lineNumbers");
                lpexView.doCommand("set messageText");
            }
            this.setAction("RulerDoubleClick", this.getAction("BreakpointRulerAction"));
            try {
                IAction action = this.getAction("FindTextMenuAction");
                action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
                this.setAction(ITextEditorActionConstants.FIND, action);
                lpexView.defineAction("find", new LpexAction(){

                    public void doAction(LpexView lpexView) {
                        IAction action = DebuggerEditor.this.getAction("FindTextMenuAction");
                        if (action != null) {
                            action.run();
                        }
                    }

                    public boolean available(LpexView lpexView) {
                        IAction action = DebuggerEditor.this.getAction("FindTextMenuAction");
                        return action != null && action.isEnabled();
                    }
                });
                action = this.getAction("FindNextMenuAction");
                action.setActionDefinitionId("c-n");
                this.setAction("c-n", action);
                action.setActionDefinitionId("org.eclipse.ui.edit.findNext");
                this.setAction("org.eclipse.ui.edit.findNext", action);
                this.setAction("org.eclipse.ui.edit.findPrevious", null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        try {
            ((DebuggerMarkerAnnotationModel)this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput())).resetMarkers();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setCurrentExecutionLineColor();
        lpexView.doDefaultCommand("set commandLine off");
        lpexView.defineAction("zoomin", new LpexAction(){

            public void doAction(LpexView view) {
                DebuggerEditor.this.adjustFont(view, true);
            }

            public boolean available(LpexView arg0) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.c-plus zoomin");
        lpexView.doCommand("set keyAction.c-equals zoomin");
        lpexView.defineAction("zoomout", new LpexAction(){

            public void doAction(LpexView view) {
                DebuggerEditor.this.adjustFont(view, false);
            }

            public boolean available(LpexView arg0) {
                return true;
            }
        });
        lpexView.doCommand("set keyAction.c-minus zoomout");
        super.updateProfile(lpexView);
    }

    protected void createActions() {
        this.dbgEd.createDebugRulerActions((ITextEditor)this, this.getVerticalRuler());
        this.dbgEd.createDebugMenuActions((ITextEditor)this);
        this.fDefaultLPEXFindTextAction = this.getAction(ITextEditorActionConstants.FIND);
        this.fDefaultLPEXFindNextAction = this.getAction("org.eclipse.ui.edit.findNext");
        this.fDefaultLPEXFindPrevAction = this.getAction("org.eclipse.ui.edit.findPrevious");
        FilePrintAction filePrintAction = new FilePrintAction(this);
        this.setAction(ITextEditorActionConstants.PRINT, (IAction)filePrintAction);
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return false;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        this.dbgEd.addDebugEditorMenuActions(menu, 1043935);
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        this.dbgEd.addDebugEditorRulerActions(menu, 95);
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected boolean addLines(LpexView lpexView, int neededLine) {
        IEditorInput input;
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, "Lpex is requesting line:" + neededLine);
        }
        if (!((input = this.getEditorInput()) instanceof EngineSuppliedViewEditorInput)) {
            return false;
        }
        try {
            EngineSuppliedViewEditorInput engineViewEI = (EngineSuppliedViewEditorInput)input;
            if (engineViewEI.getViewFile().isDynamic()) {
                int line = lpexView.lineOfElement(lpexView.currentElement());
                if (neededLine - line > 101 || line - neededLine > 101) {
                    engineViewEI.ensureRange(neededLine);
                } else {
                    engineViewEI.ensureRange(line);
                }
            } else {
                engineViewEI.ensureRange(neededLine);
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
            return false;
        }
        return true;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            switch (events[i].getKind()) {
                case 8: {
                    Object source = events[i].getSource();
                    if (!(source instanceof DebuggeeProcess)) break;
                    IDebugTarget sourceDbgTgt = ((DebuggeeProcess)source).getDebugTarget();
                    IEditorInput input = this.getEditorInput();
                    PICLDebugTarget dbgtgt = null;
                    if (input instanceof EngineSuppliedViewEditorInput) {
                        dbgtgt = ((EngineSuppliedViewEditorInput)input).getPICLDebugTarget();
                        if (dbgtgt != sourceDbgTgt) break;
                        this.close(false);
                        break;
                    }
                    try {
                        ((DebuggerMarkerAnnotationModel)this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput())).resetMarkers();
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
            }
            ++i;
        }
    }

    public void partAdded(PartAddedEvent event) {
    }

    public void partDeleted(PartDeletedEvent event) {
        if (event.getPart().equals(this.fPart)) {
            this.close(false);
        }
    }

    public void moduleUnloaded(ModuleUnloadedEvent event) {
        if (event.getModule().equals(this.fModule)) {
            this.close(false);
        }
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        if (!(newInput instanceof EngineSuppliedViewEditorInput)) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), "Invalid editor input");
            throw new CoreException((IStatus)status);
        }
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput instanceof EngineSuppliedViewEditorInput) {
            if (this.fModule != null) {
                this.fModule.removeListener((IModelEventListener)this);
                this.fModule = null;
                this.fPart = null;
            }
            ((EngineSuppliedViewEditorInput)oldInput).setCurrentlyDisplayed(false);
        }
        try {
            EngineSuppliedViewEditorInput engineInput = (EngineSuppliedViewEditorInput)newInput;
            engineInput.setCurrentlyDisplayed(true);
            engineInput.ensureRange(engineInput.getInitialLine());
            AbstractEditorFile view = (AbstractEditorFile)engineInput.getStorage();
            if (view == null) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString((Object)this, "DebuggerEditor.doSetInput(IEditorInput): EngineSuppliedView was null", 2);
                }
            } else {
                this.setDocumentSection(view);
            }
            try {
                this.fPart = engineInput.getViewFile().getPart();
                this.fModule = this.fPart.getModule();
                this.fModule.addEventListener((IModuleEventListener)this);
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
            LpexView lpexView = this.getLpexView();
            if (lpexView != null) {
                lpexView.doCommand("set sequenceNumbers 1 0 1 0");
            }
            super.doSetInput(newInput);
            this.setHelpContextId(PICLUtils.getHelpResourceString("debugger_editor"));
        }
        catch (Exception e) {
            PICLUtils.logError(e);
            EngineSuppliedViewEditorInput engineInput = (EngineSuppliedViewEditorInput)newInput;
            boolean isTerminating = false;
            try {
                isTerminating = engineInput.getPICLDebugTarget().getDebugEngine().isProgramTerminating();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            super.doSetInput((IEditorInput)new CommonSourceNotFoundEditorInput((Object)engineInput.getName()));
            if (!isTerminating) {
                PICLDebugPlugin.showMessageDialog(null, NLS.bind((String)PICLMessages.picl_storage_map_error_file_error, (Object)newInput.getName()), false);
            }
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DebuggerEditor.this.close(false);
                }
            });
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        if (element instanceof AbstractEditorFile && this.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            try {
                if (element.equals(((EngineSuppliedViewEditorInput)this.getEditorInput()).getStorage())) {
                    final EngineSuppliedViewEditorInput engineViewEI = (EngineSuppliedViewEditorInput)this.getEditorInput();
                    final AbstractEditorFile engineFile = (AbstractEditorFile)engineViewEI.getStorage();
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DebuggerEditor.this.getDocumentProvider().changed((Object)engineViewEI);
                                InputStream stream = null;
                                try {
                                    stream = engineFile.getContents();
                                }
                                catch (CoreException e) {
                                    PICLUtils.logError((Exception)((Object)e));
                                }
                                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                                DebuggerEditor.this.getLpexView().load((Reader)reader);
                                DebuggerEditor.this.setDocumentSection(engineFile);
                                try {
                                    ((DebuggerMarkerAnnotationModel)DebuggerEditor.this.getDocumentProvider().getAnnotationModel((Object)DebuggerEditor.this.getEditorInput())).resetMarkers();
                                }
                                catch (NullPointerException nullPointerException) {
                                    // empty catch block
                                }
                                int lineNumber = PICLUtils.getBufferedLineNumber(DebuggerEditor.this.getEditorInput(), DebuggerEditor.this.fCurrentExecutionLine);
                                int lpexElement = DebuggerEditor.this.getLpexView().elementOfLine(lineNumber);
                                if (lpexElement > 0) {
                                    LpexView lpexView = DebuggerEditor.this.getLpexView();
                                    LpexDocumentLocation loc = new LpexDocumentLocation(lpexElement, 1);
                                    if (lpexView.query("includedClasses").length() != 0) {
                                        lpexView.doCommand("set includedClasses");
                                    }
                                    DebuggerEditor.this.hiliteLine(lpexView, loc);
                                    lpexView.doCommand("screenShow document");
                                }
                            }
                            catch (UnsupportedEncodingException e) {
                                PICLUtils.logError(e);
                            }
                        }
                    });
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void elementDeleted(Object element) {
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    public void doRevertToSaved() {
        if (!(this.getEditorInput() instanceof EngineSuppliedViewEditorInput)) {
            super.doRevertToSaved();
        }
    }

    public boolean hasISeriesSequenceNumbers(int prefixLength) {
        String strLine = null;
        int iValue = 0;
        LpexView lpexView = this.getLpexView();
        int i = 0;
        while (i < 4) {
            strLine = lpexView.elementFullText(i + 1);
            if (strLine == null) {
                return i != 0;
            }
            try {
                strLine = strLine.substring(prefixLength);
            }
            catch (StringIndexOutOfBoundsException se) {
                return false;
            }
            if (strLine.length() < 6) {
                return false;
            }
            strLine = strLine.substring(0, 6);
            int iNonZeroIndex = 0;
            int j = 0;
            while (j < 6) {
                if (strLine.charAt(j) != '0') {
                    iNonZeroIndex = j;
                    break;
                }
                ++j;
            }
            if (iNonZeroIndex > 0) {
                strLine = strLine.substring(iNonZeroIndex);
            }
            try {
                iValue = Integer.decode(strLine);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (iValue < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("center_view_execution")) {
            this.fCenterOnExecutionLine = PreferenceUI.isCenterOnExecution();
        } else if (event.getProperty().equals("execution_line_colour")) {
            this.fExecutionLineColour = PreferenceUI.getExecutionLineColor();
            this.setCurrentExecutionLineColor();
        }
        LpexView lpexView = this.getActiveLpexView();
        if (lpexView != null && this.resetPalette(lpexView)) {
            lpexView.doCommand("updateProfile");
        }
    }

    private void setCurrentExecutionLineColor() {
        String toBackground = LpexPaletteAttributes.background((LpexView)this.getActiveLpexView());
        Object lineColor = String.valueOf(this.fExecutionLineColour.red) + " " + String.valueOf(this.fExecutionLineColour.green) + " " + String.valueOf(this.fExecutionLineColour.blue);
        if (this.fExecutionLineColour.equals((Object)PreferenceUI.getDefaultExecutionLineColor()) && DebuggerEditor.isDarkTheme()) {
            lineColor = "200 200 200";
        }
        Object colorString = LpexPaletteAttributes.convert((String)("-1 -1 -1 " + (String)lineColor), (String)"255 255 255", (String)toBackground);
        if (this.fExecutionLineColour.equals((Object)PreferenceUI.getDefaultExecutionLineColor()) && DebuggerEditor.isHighContrastTheme()) {
            RGB background = Display.getCurrent().getSystemColor(26).getRGB();
            RGB foreground = Display.getCurrent().getSystemColor(27).getRGB();
            colorString = String.format("%s %s %s %s %s %s", foreground.red, foreground.green, foreground.blue, background.red, background.green, background.blue);
        }
        if (!this.fExecutionLineColour.equals((Object)PreferenceUI.getDefaultExecutionLineColor()) && DebuggerEditor.isDarkTheme()) {
            colorString = "-1 -1 -1 " + (String)lineColor;
        }
        LpexView lpexView = this.getLpexView();
        lpexView.doDefaultCommand("set styleAttributes.D " + (String)colorString);
        lpexView.doCommand("screenShow document");
    }

    public int getCurrentExecutionPointLineNumber() {
        return this.fCurrentExecutionLine;
    }

    public void setCurrentExecutionPointLineNumber(int lineNumber) {
        this.fCurrentExecutionLine = lineNumber;
    }

    public void clearCurrentExecutionPointHighlighting() {
        LpexView lpexView = this.getLpexView();
        if (lpexView != null) {
            try {
                lpexView.doDefaultCommand("set markHighlight.PDTDebugPosn off");
                lpexView.doCommand("screenShow document");
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    public void hiliteWord(int lineNumber, int columnNumber, int wordLength) {
        int element;
        LpexView lpexView = this.getLpexView();
        if (lpexView.query("includedClasses").length() != 0) {
            lpexView.doCommand("set includedClasses");
        }
        if (this.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            EngineSuppliedViewEditorInput esvEI = (EngineSuppliedViewEditorInput)this.getEditorInput();
            int prefixLength = esvEI.getPrefixLength();
            lineNumber = PICLUtils.getBufferedLineNumber((IEditorInput)esvEI, lineNumber);
            columnNumber += prefixLength;
            if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)esvEI.getPICLDebugTarget()) && this.hasISeriesSequenceNumbers(prefixLength)) {
                columnNumber -= 12;
            }
        }
        if ((element = lpexView.elementOfLine(lineNumber)) <= 0) {
            return;
        }
        LpexDocumentLocation start = new LpexDocumentLocation(element, columnNumber);
        LpexDocumentLocation end = new LpexDocumentLocation(element, columnNumber + wordLength - 1);
        lpexView.doDefaultCommand("block clear");
        String type = lpexView.query("current.block.defaultType");
        if (type.equals("element")) {
            type = "stream";
        }
        if (type.equals("stream")) {
            ++end.position;
        }
        lpexView.jump(end);
        lpexView.doDefaultCommand(start, "block set " + type);
        lpexView.doDefaultCommand("block set");
        lpexView.doCommand("screenShow document");
    }

    public void hiliteLine(int lineNumber) {
        int element;
        LpexView lpexView = this.getLpexView();
        if (lpexView.query("includedClasses").length() != 0) {
            lpexView.doCommand("set includedClasses");
        }
        if ((element = lpexView.elementOfLine(lineNumber = PICLUtils.getBufferedLineNumber(this.getEditorInput(), lineNumber))) <= 0) {
            return;
        }
        LpexDocumentLocation loc = new LpexDocumentLocation(element, 1);
        this.hiliteLine(lpexView, loc);
    }

    private void hiliteLine(LpexView lpexView, LpexDocumentLocation loc) {
        lpexView.doDefaultCommand(loc, "set mark.PDTDebugPosn element");
        lpexView.doDefaultCommand("set markStyle.PDTDebugPosn D");
        lpexView.doDefaultCommand("set markHighlight.PDTDebugPosn on");
        lpexView.doCommand("screenShow document");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.ibm.debug.pdt.ui.debuggerEditorScope"});
    }

    protected void setKeyBindingScopes(String[] scopes) {
        if (scopes == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(scopes));
        list.add(0, "com.ibm.debug.pdt.ui.debuggerEditorScope");
        super.setKeyBindingScopes(list.toArray(new String[list.size()]));
    }

    protected boolean setDocumentSection(AbstractEditorFile storageFile) {
        int linesBefore = Math.max(0, storageFile.getBufferStartLine() - storageFile.getFileStartLine());
        int linesAfter = Math.max(0, storageFile.getFileEndLine() - storageFile.getBufferEndLine());
        return this.setDocumentSection(linesBefore, linesAfter);
    }

    public void debugContextChanged(DebugContextEvent event) {
        try {
            ((DebuggerMarkerAnnotationModel)this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput())).resetMarkers();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setHelpContextId(PICLUtils.getHelpResourceString("debugger_editor"));
    }

    public void initializeLpexView(LpexView lpexView) {
        lpexView.addLpexViewListener((LpexViewListener)this.fViewListener);
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.default.dark %s %s %s %s %s %s ", 240, 240, 240, 50, 50, 50));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.formatLine.dark %s %s %s %s %s %s ", 240, 240, 240, 50, 50, 50));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.messageLine.dark %s %s %s %s %s %s ", 240, 240, 240, 50, 50, 50));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.currentLine.dark  %s %s %s %s %s %s", 240, 240, 240, 75, 75, 75));
        RGB dftBackground = Display.getCurrent().getSystemColor(25).getRGB();
        RGB dftForeground = Display.getCurrent().getSystemColor(24).getRGB();
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.default.hc %s %s %s %s %s %s ", dftForeground.red, dftForeground.green, dftForeground.blue, dftBackground.red, dftBackground.green, dftBackground.blue));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.background.hc %s %s %s %s %s %s ", dftForeground.red, dftForeground.green, dftForeground.blue, dftBackground.red, dftBackground.green, dftBackground.blue));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.cursor.hc %s %s %s %s %s %s ", dftBackground.red, dftBackground.green, dftBackground.blue, dftForeground.red, dftForeground.green, dftForeground.blue));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.formatLine.hc %s %s %s %s %s %s ", dftForeground.red, dftForeground.green, dftForeground.blue, dftBackground.red, dftBackground.green, dftBackground.blue));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.messageLine.hc %s %s %s %s %s %s ", dftForeground.red, dftForeground.green, dftForeground.blue, dftBackground.red, dftBackground.green, dftBackground.blue));
        lpexView.doCommand(String.format("set updateProfile.paletteAttributes.currentLine.hc  %s %s %s %s %s %s %s %s %s outline", -1, -1, -1, dftBackground.red, dftBackground.green, dftBackground.blue, dftForeground.red, dftForeground.green, dftForeground.blue));
        this.resetPalette(lpexView);
        if (this.isSavedFontOk(lpexView)) {
            lpexView.doCommand("set font " + fFont);
        }
    }

    private boolean resetPalette(LpexView lpexView) {
        String currentPallete = lpexView.query("current.updateProfile.palette");
        String palette = null;
        palette = DebuggerEditor.isDarkTheme() ? "dark" : (DebuggerEditor.isHighContrastTheme() ? "hc" : lpexView.query("install.updateProfile.palette"));
        if (!palette.equals(currentPallete)) {
            return lpexView.doCommand("set updateProfile.palette " + palette);
        }
        return false;
    }

    public void handleEvent(Event event) {
        if (this.resetPalette(this.getActiveLpexView())) {
            this.getActiveLpexView().doCommand("updateProfile");
        }
    }

    private void adjustFont(LpexView view, boolean zoomin) {
        String fontName = view.query("current.font");
        if (fontName != null) {
            int idx = fontName.lastIndexOf("-");
            boolean endsInQuote = fontName.endsWith("\"");
            if (idx > -1) {
                try {
                    int end = endsInQuote ? fontName.length() - 1 : fontName.length();
                    int size = Integer.parseInt(fontName.substring(idx + 1, end));
                    if (zoomin) {
                        ++size;
                    } else if (size > 1) {
                        --size;
                    }
                    fFont = endsInQuote ? fontName.substring(0, idx + 1) + size + "\"" : fontName.substring(0, idx + 1) + size;
                    view.doCommand("set font " + fFont);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isSavedFontOk(LpexView view) {
        int idx;
        String fontName;
        int idx2;
        if (fFont != null && (idx2 = fFont.lastIndexOf("-")) > -1 && (fontName = view.query("current.font")) != null && (idx = fontName.lastIndexOf("-")) > -1) {
            return fontName.substring(0, idx).equals(fFont.substring(0, idx2));
        }
        return false;
    }

    private static class DebuggerViewParserPreferencePage
    extends ViewParserPreferencePage {
        public DebuggerViewParserPreferencePage(LpexView lpexView) {
            super(lpexView);
        }

        protected Control createContents(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            GridData data = new GridData(0, 0, true, true);
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setText(PICLMessages.sourceSearch_unsupportedError);
            return parent;
        }

        protected void performDefaults() {
        }

        public boolean performOk() {
            return true;
        }

        protected void performReset() {
        }
    }
}

