/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SourceSearchPathDialog
extends DebugStatusDialog {
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".sourceSearchPathDialog";
    private Text fSourceSearchpath;
    private Label fMsgLabel;
    private PDTDebugTarget fDebugTarget;

    public SourceSearchPathDialog(Shell parent, PDTDebugTarget dbgtgt) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDebugTarget = dbgtgt;
        this.setTitle(PICLLabels.SourceSearchDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PICLUtils.getHelpResourceString("source_search_path_dialog"));
    }

    protected void okPressed() {
        this.fDebugTarget.getDebugEngine().setLocalSourcePath(this.fSourceSearchpath.getText());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        GridData parentSpec = new GridData();
        parentSpec.grabExcessVerticalSpace = true;
        parentSpec.grabExcessHorizontalSpace = true;
        parentSpec.horizontalAlignment = 4;
        parentSpec.verticalAlignment = 2;
        comp.setLayoutData((Object)parentSpec);
        this.fMsgLabel = new Label(comp, 0);
        this.fMsgLabel.setText(PICLLabels.SourceSearchDialog_label_description);
        this.fSourceSearchpath = new Text(comp, 2304);
        GridData pathSpec = new GridData();
        pathSpec.grabExcessVerticalSpace = false;
        pathSpec.grabExcessHorizontalSpace = true;
        pathSpec.horizontalAlignment = 4;
        pathSpec.verticalAlignment = 1;
        this.fSourceSearchpath.setLayoutData((Object)pathSpec);
        String searchPath = this.fDebugTarget.getDebugEngine().getLocalSourcePath();
        if (searchPath == null) {
            searchPath = "";
        }
        this.fSourceSearchpath.setText(searchPath);
        SourceSearchPathDialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

