/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SourceLineBPInfoDialog
extends DebugTrayDialog {
    public static final int SEARCH = 0;
    public static final int FOLLOW_CHILD = 1;
    public static final int ALWAYS_FOLLOW_PARENT = 3;
    public static final int ALWAYS_FOLLOW_CHILD = 4;
    private PICLDebugTarget fDbgTgt;
    private IMarker fMarker;
    private Text fExecutableField;
    private Text fObjectField;
    private Text fFileField;
    private Text fLineField;
    private Button fSearchButton;
    private Text fUserLabelField;

    public SourceLineBPInfoDialog(Shell parent, PICLDebugTarget target, IMarker marker) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDbgTgt = target;
        this.fMarker = marker;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.LineBPWizard_page1_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Label msgLabel1 = new Label(composite, 0);
        msgLabel1.setText(PICLMessages.DebugFileContextsDialog_error1);
        Label msgLabel2 = new Label(composite, 0);
        msgLabel2.setText(PICLLabels.ManageDebugContextsDialog_desc1);
        Label exeLabel = new Label(composite, 16384);
        exeLabel.setText(PICLLabels.LineBPWizard_page1_execLabel);
        this.fExecutableField = new Text(composite, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fExecutableField.setLayoutData((Object)gd);
        String exeText = this.fMarker.getAttribute("moduleName", "not_defined");
        if (!"not_defined".equals(exeText)) {
            this.fExecutableField.setText(exeText);
        }
        this.fExecutableField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceLineBPInfoDialog.this.updateDialog();
            }
        });
        Label objLabel = new Label(composite, 16384);
        objLabel.setText(PICLLabels.LineBPWizard_page1_objectLabel);
        this.fObjectField = new Text(composite, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fObjectField.setLayoutData((Object)gd);
        String objText = this.fMarker.getAttribute("objectName", "not_defined");
        if (!"not_defined".equals(objText)) {
            this.fObjectField.setText(objText);
        }
        this.fObjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceLineBPInfoDialog.this.updateDialog();
            }
        });
        Label fileLabel = new Label(composite, 16384);
        fileLabel.setText(Action.removeMnemonics((String)PICLLabels.LineBPWizard_page1_sourceLabel));
        this.fFileField = new Text(composite, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fFileField.setLayoutData((Object)gd);
        this.fFileField.setEditable(false);
        String fileName = this.fMarker.getResource().getName();
        this.fFileField.setText(fileName);
        Label lineLabel = new Label(composite, 16384);
        lineLabel.setText(Action.removeMnemonics((String)PICLLabels.LineBPWizard_page1_lineLabel));
        this.fLineField = new Text(composite, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fLineField.setLayoutData((Object)gd);
        this.fLineField.setEditable(false);
        int lineNumber = this.fMarker.getAttribute("lineNumber", 0);
        this.fLineField.setText(Integer.toString(lineNumber));
        this.fSearchButton = new Button(composite, 32);
        this.fSearchButton.setText(PICLLabels.ManageDebugContextsDialog_loaded);
        this.fSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SourceLineBPInfoDialog.this.updateDialog();
            }
        });
        Label userLabel = new Label(composite, 16384);
        userLabel.setText(PICLLabels.LineBPWizard_page1_userLabel);
        this.fUserLabelField = new Text(composite, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fUserLabelField.setLayoutData((Object)gd);
        this.fUserLabelField.setEditable(false);
        String label = this.fMarker.getAttribute("userLabel", "");
        if (!PDTCoreUtils.isEmpty((String)label) && !label.equals("!NULL!")) {
            this.fUserLabelField.setText(label);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("source_line_bp_info_dialog"));
        return composite;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        this.updateDialog();
        return ctrl;
    }

    private void updateDialog() {
        boolean doSearch = this.fSearchButton.getSelection();
        this.fExecutableField.setEnabled(!doSearch);
        this.fObjectField.setEnabled(!doSearch);
        if (doSearch) {
            if (!this.fExecutableField.getText().isEmpty()) {
                this.fExecutableField.setText("");
            }
            if (!this.fObjectField.getText().isEmpty()) {
                this.fObjectField.setText("");
            }
            this.getButton(0).setEnabled(true);
        } else if (!this.fExecutableField.getText().isEmpty() && !this.fObjectField.getText().isEmpty()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            this.fDbgTgt.setSourceLineBPInfoDialogAnswer(null);
        }
        return super.close();
    }

    protected void okPressed() {
        if (this.fSearchButton.getSelection()) {
            this.fDbgTgt.setSourceLineBPInfoDialogAnswer(new String[0]);
        } else {
            final String exe = this.fExecutableField.getText();
            final String obj = this.fObjectField.getText();
            this.fDbgTgt.setSourceLineBPInfoDialogAnswer(new String[]{exe, obj});
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        SourceLineBPInfoDialog.this.fMarker.setAttributes(new String[]{"moduleName", "objectName"}, (Object[])new String[]{exe, obj});
                        PICLUtils.updateResourceSourceLineBPInfoMarker(SourceLineBPInfoDialog.this.fMarker.getResource(), exe, obj);
                    }
                };
                workspace.run(runnable, (ISchedulingRule)this.fMarker.getResource(), 1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        super.okPressed();
    }
}

