/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;

public class ShowViewDialog
extends DebugTrayDialog {
    private PDTDebugTarget fDbgtgt = null;
    private ITextEditor fEditor = null;
    ViewInformation fViewInfo = null;

    public ShowViewDialog(Shell parent, PDTDebugTarget dbgtgt, ITextEditor editor) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDbgtgt = dbgtgt;
        this.fEditor = editor;
    }

    private boolean supportsView(ViewFile viewFile, ViewInformation viewInfo) {
        try {
            if (viewFile.getPart().getView(viewInfo) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(PICLLabels.DebugViewMenuListener_showView3);
        parent.setLayout((Layout)new GridLayout());
        if (this.fDbgtgt == null || this.fDbgtgt.isTerminated()) {
            Label label = new Label(parent, 0);
            label.setText(PICLMessages.MonitorExpressionDialog_error_invalid_thread);
            return parent;
        }
        ViewFile viewFile = PICLUtils.getViewFile(this.fEditor.getEditorInput());
        if (viewFile == null) {
            Label label = new Label(parent, 0);
            label.setText(PICLMessages.DebugViewMenuListener_error1);
            return parent;
        }
        ViewInformation[] engineViews = this.fDbgtgt.getDebugEngine().getSupportedViews();
        int mnemonicIndex = 1;
        boolean hasAlternateViews = false;
        int i = 0;
        while (i < engineViews.length) {
            if (engineViews[i] != null && !engineViews[i].isSourceView() && this.supportsView(viewFile, engineViews[i])) {
                hasAlternateViews = true;
                final Button viewButton = new Button(parent, 16);
                viewButton.setLayoutData((Object)new GridData());
                viewButton.setText("&" + mnemonicIndex + " " + engineViews[i].getName());
                viewButton.setData("viewIndex", (Object)engineViews[i]);
                ++mnemonicIndex;
                viewButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ShowViewDialog.this.fViewInfo = (ViewInformation)viewButton.getData("viewIndex");
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            ++i;
        }
        if (!hasAlternateViews) {
            Label label = new Label(parent, 0);
            label.setText(PICLMessages.DebugViewMenuListener_error1);
            return parent;
        }
        return parent;
    }

    protected void okPressed() {
        Location newLocation;
        ViewFile vf = PICLUtils.getViewFile(this.fEditor.getEditorInput());
        Object context = vf.getContext();
        Location currentLocation = new Location(vf, PICLUtils.getLineNumber((IEditorPart)this.fEditor));
        try {
            newLocation = vf.getDebugEngine().switchView(currentLocation, this.fViewInfo);
        }
        catch (EngineRequestException e) {
            newLocation = currentLocation;
        }
        Part part = vf.getPart();
        part.setCurrentView(part.getView(this.fViewInfo));
        IWorkbenchPage page = this.fEditor.getEditorSite().getPage();
        PICLUtils.resetEditor(context, page, newLocation.getLineNumber());
        super.okPressed();
    }
}

