/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewProcessDialog
extends DebugTrayDialog {
    private Button debugInitButton;
    private int result = -1;
    private PICLDebugTarget debugTarget;
    public static final int DEBUG_INITIALIZATION = 0;
    public static final int RUN_TO_MAIN = 1;

    public NewProcessDialog(Shell shell, PICLDebugTarget target) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.debugTarget = target;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.NewProcessDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, PICLUtils.getHelpResourceString("new_process_dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label l = new Label(composite, 0);
        l.setText(PICLLabels.NewProcessDialog_message);
        String message = null;
        try {
            message = ((DebuggeeProcess)this.debugTarget.getProcess()).getProcessStopInfo().getExceptionMsg();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message == null) {
            message = PICLLabels.debug_element_unknown;
        }
        l = new Label(composite, 0);
        l.setText(message);
        this.debugInitButton = new Button(composite, 32);
        this.debugInitButton.setText(PICLLabels.NewProcessDialog_debugInitializationCheckbox);
        boolean debugInitEnabled = true;
        try {
            debugInitEnabled = this.debugTarget.getStoppingThread().getLocation().getPart().getModule().hasDebugInfo();
        }
        catch (NullPointerException e) {
            debugInitEnabled = false;
        }
        if (!debugInitEnabled) {
            this.debugInitButton.setSelection(true);
            this.debugInitButton.setEnabled(false);
        }
        Button b = new Button(composite, 0);
        b.setText(PICLLabels.NewProcessDialog_defaultButton);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        this.result = this.debugInitButton.getSelection() ? 0 : 1;
        this.debugTarget.setNewProcessDialogAnswer(this.result);
        super.okPressed();
    }

    protected void handleShellCloseEvent() {
    }

    public int getResult() {
        return this.result;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }
}

