/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ModuleLoadBreakpoint;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.LoadBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class LoadBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "LoadBPWizard.dialog";
    protected static final String PAGE_1 = "LoadBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private ModuleLoadBreakpoint existingBP;

    public LoadBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.fEditing = false;
        this.existingBP = null;
        this.initializeWizard();
    }

    public LoadBPWizard(PDTDebugTarget debugTarget, ModuleLoadBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.LoadBPWizard_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.LoadBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.LoadBPWizard_page1_pageName;
        this.addPage((IWizardPage)new LoadBPWizardPage(this.fMainPageName, PICLLabels.LoadBPWizard_page1_title, null, this.fDebugTarget, this.existingBP));
        if (this.areOptionalParametersSupported()) {
            ConditionalBreakpointWizardPage condPage = new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP);
            condPage.setSupportsExpressionField(false);
            condPage.setSupportsActionField(false);
            this.addPage((IWizardPage)condPage);
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final LoadBPWizardPage page = (LoadBPWizardPage)this.getPage(this.fMainPageName);
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        final String dllName = page.getDLLName();
        final OptionalBreakpointData optData = condPage.getPageData();
        optData.setUserLabel(page.getUserLabel());
        final boolean isRunToEntry = page.getRunToEntry();
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created;
                final StatusInfo processResult = created = LoadBPWizard.this.processBreakpoint(dllName, optData, isRunToEntry);
                if (!page.getControl().isDisposed()) {
                    LoadBPWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            LoadBPWizard.this.updateWizardPostProcessing(processResult, page, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    LoadBPWizard.this.wbJob.setSystem(true);
                    LoadBPWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processBreakpoint(String dllName, OptionalBreakpointData optData, boolean isRunToEntry) {
        StatusInfo status = new StatusInfo();
        if (dllName == null || dllName.equals("")) {
            status.setError(PICLMessages.LoadBPWizard_page1_dllError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (!this.fEditing) {
                this.fDebugTarget.createLoadBreakpoint(true, dllName, optData, null, isRunToEntry);
            } else {
                this.existingBP.modify(dllName, optData);
            }
        }
        catch (EngineRequestErrorException ere) {
            if (ere.getReturnCode() == 328) {
                status.setWarning(ere.getMessage());
            } else {
                status.setError(ere.getMessage());
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

