/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.LineBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.LineBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class LineBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "LineBPWizard.dialog";
    protected static final String PAGE_1 = "LineBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private LineBreakpoint existingBP;

    public LineBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.fEditing = false;
        this.existingBP = null;
        this.initializeWizard();
    }

    public LineBPWizard(PDTDebugTarget debugTarget, LineBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private String getLineOrStatementTitle() {
        if (this.fDebugTarget != null && this.fDebugTarget.supportsStatementBreakpoints()) {
            if (!this.fEditing) {
                return PICLLabels.LineBPWizard_dialog_title_statement;
            }
            return PICLLabels.LineBPWizard_dialog_title2_statement;
        }
        if (!this.fEditing) {
            return PICLLabels.LineBPWizard_dialog_title;
        }
        return PICLLabels.LineBPWizard_dialog_title2;
    }

    private void initializeWizard() {
        this.setWindowTitle(this.getLineOrStatementTitle());
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.LineBPWizard_page1_pageName;
        this.addPage((IWizardPage)new LineBPWizardPage(this.fMainPageName, PICLLabels.LineBPWizard_page1_title, null, this.fDebugTarget, this.existingBP));
        if (this.areOptionalParametersSupported()) {
            this.addPage((IWizardPage)new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP));
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final LineBPWizardPage page = (LineBPWizardPage)this.getPage(this.fMainPageName);
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        final boolean isDeferred = page.isDeferred();
        final String exe = page.getExecutableName();
        final String obj = page.getObjectName();
        final String file = page.getFileName();
        final String stmt = page.getStatementNumber();
        final int line = page.getLineNumber();
        final ViewFile vf = page.getViewFileField();
        final OptionalBreakpointData optData = condPage.getPageData();
        optData.setUserLabel(page.getUserLabel());
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created = null;
                created = isDeferred || LineBPWizard.this.existingBP != null && LineBPWizard.this.existingBP.isSourceLineBreakpoint() ? LineBPWizard.this.processDeferredBreakpoint(exe, obj, file, line, stmt, optData) : LineBPWizard.this.processBreakpoint(vf, line, stmt, optData);
                final StatusInfo processResult = created;
                if (!page.getControl().isDisposed()) {
                    LineBPWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            LineBPWizard.this.updateWizardPostProcessing(processResult, page, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    LineBPWizard.this.wbJob.setSystem(true);
                    LineBPWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processBreakpoint(ViewFile viewFile, int lineNumber, String stmtNumber, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        Location loc = new Location(viewFile, lineNumber);
        try {
            if (!this.fEditing) {
                this.fDebugTarget.createLineBreakpoint(true, loc, stmtNumber, optData, null, null);
            } else if (this.existingBP.isDeferred()) {
                this.fDebugTarget.createLineBreakpoint(true, loc, stmtNumber, optData, null, null);
                this.existingBP.remove();
            } else {
                this.existingBP.modify(true, loc, stmtNumber, optData, null, null);
            }
        }
        catch (EngineRequestErrorException ere) {
            status.setError(ere.getMessage());
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }

    private StatusInfo processDeferredBreakpoint(String moduleName, String partName, String fileName, int lineNumber, String stmtNumber, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (lineNumber <= 0 && (stmtNumber == null || stmtNumber.trim().equals(""))) {
            status.setError(PICLMessages.LineBPWizard_page1_lineError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (!this.fEditing) {
                this.fDebugTarget.createDeferredLineBreakpoint(true, lineNumber, stmtNumber, moduleName, partName, fileName, optData, null);
            } else if (!this.existingBP.isDeferred()) {
                this.fDebugTarget.createDeferredLineBreakpoint(true, lineNumber, stmtNumber, moduleName, partName, fileName, optData, null);
                this.existingBP.remove();
            } else {
                this.existingBP.modifyDeferred(true, lineNumber, stmtNumber, moduleName, partName, fileName, optData, null, false);
            }
        }
        catch (EngineRequestErrorException ere) {
            status.setError(ere.getMessage());
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

