/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.GlobalVariable;
import com.ibm.debug.pdt.internal.ui.GlobalVariableItem;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.pdt.internal.ui.util.CheckedList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GlobalListDialog
extends DebugTrayDialog {
    private static final GlobalVariable[] EMPTYGLOBALVARS = new GlobalVariable[0];
    private static final GlobalVariableItem[] EMPTYGLOBALITEMS = new GlobalVariableItem[0];
    private PDTDebugTarget fDebugTarget;
    protected CheckedList fGlobalsListControl;
    private GlobalVariableItem[] fItems = EMPTYGLOBALITEMS;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".globalListDialog";

    public GlobalListDialog(Shell parentShell, PDTDebugTarget debugTarget) {
        super(parentShell);
        this.fDebugTarget = debugTarget;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 400;
        parent.setLayoutData((Object)gd);
        Label l = new Label(parent, 0);
        l.setText(PICLLabels.MonitorGlobalsDialog_searchlabel);
        this.fGlobalsListControl = new CheckedList(parent, true, false);
        this.fGlobalsListControl.setLayoutData(new GridData(4, 4, true, true));
        this.initializeList();
        Composite buttonArea = new Composite(parent, 0);
        buttonArea.setLayout((Layout)new GridLayout(2, false));
        Button checkAllButton = new Button(buttonArea, 8);
        checkAllButton.setText(PICLLabels.MonitorGlobalsDialog_checkAllAction);
        checkAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GlobalListDialog.this.fGlobalsListControl.checkAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button uncheckAllButton = new Button(buttonArea, 8);
        uncheckAllButton.setText(PICLLabels.MonitorGlobalsDialog_uncheckAllAction);
        uncheckAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GlobalListDialog.this.fGlobalsListControl.uncheckAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PICLLabels.MonitorGlobalsDialog_label2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, PICLUtils.getHelpResourceString("global_list_dialog"));
    }

    private void initializeList() {
        if (this.fDebugTarget.getDebugEngine() == null) {
            return;
        }
        GlobalVariable[] variables = EMPTYGLOBALVARS;
        try {
            variables = this.fDebugTarget.getDebugEngine().getGlobalVariables();
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        if (variables.length == 0) {
            return;
        }
        this.fItems = new GlobalVariableItem[variables.length];
        int i = 0;
        while (i < this.fItems.length) {
            this.fItems[i] = new GlobalVariableItem(variables[i], this.fDebugTarget);
            ++i;
        }
        this.fGlobalsListControl.setElements(this.fItems);
        this.fGlobalsListControl.setFilter("*", true);
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.fItems.length) {
            try {
                this.fItems[i].process();
            }
            catch (EngineRequestException e) {
                PICLDebugPlugin.showMessageDialog(this.getShell(), e.getMessage(), true);
                return;
            }
            ++i;
        }
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

