/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.ISettingsWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class GenericLineBPWizardPage
extends BreakpointWizardPage
implements ISettingsWriter {
    private GenericLineBreakpoint fExistingBP = null;
    private Text fExecutableField = null;
    private Label fExecutableLabel = null;
    private Text fObjectField = null;
    private Label fObjectLabel = null;
    private Text fFileField = null;
    private Label fFileLabel = null;
    private Text fLineNumberField = null;
    private Label fLineNumberLabel = null;
    private Text fUserLabelField = null;
    private Label fUserLabelLabel = null;
    private static final String PAGE_NAME = "LineBPWizard.page1";
    private static final String EXECUTABLE = "executable";
    private static final String OBJECT = "object";
    private static final String FILE = "file";
    private static final String LINE = "line";

    protected GenericLineBPWizardPage(String pageName, String title, GenericLineBreakpoint editBreakpoint) {
        super(pageName, title, null, null, editBreakpoint != null);
        this.fExistingBP = editBreakpoint;
        this.setDescription(PICLLabels.LineBPWizard_page1_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.fExecutableLabel = new Label(composite, 16384);
        this.fExecutableLabel.setText(this.getExecutableLabel());
        this.fExecutableField = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fExecutableField.setLayoutData((Object)gd);
        this.fExecutableField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericLineBPWizardPage.this.checkIfComplete();
            }
        });
        this.fObjectLabel = new Label(composite, 16384);
        this.fObjectLabel.setText(this.getObjectLabel());
        this.fObjectField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fObjectField.setLayoutData((Object)gd);
        this.fObjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericLineBPWizardPage.this.checkIfComplete();
            }
        });
        this.fFileLabel = new Label(composite, 16384);
        this.fFileLabel.setText(this.getFileLabel());
        this.fFileField = new Text(composite, 2060);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fFileField.setLayoutData((Object)gd);
        this.fLineNumberLabel = new Label(composite, 16384);
        this.fLineNumberLabel.setText(PICLLabels.LineBPWizard_page1_lineLabel);
        this.fLineNumberField = new Text(composite, 2052);
        gd = new GridData();
        gd.widthHint = 100;
        this.fLineNumberField.setLayoutData((Object)gd);
        this.fLineNumberField.setEnabled(false);
        this.fUserLabelLabel = new Label(composite, 16384);
        this.fUserLabelLabel.setText(PICLLabels.LineBPWizard_page1_userLabel);
        this.fUserLabelField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fUserLabelField.setLayoutData((Object)gd);
        this.initializePage();
        this.checkIfComplete();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, PICLUtils.getHelpResourceString("line_bp_wizard"));
        Dialog.applyDialogFont((Control)composite);
    }

    public int getLineNumber() {
        try {
            return Integer.parseInt(this.fLineNumberField.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getExecutableName() {
        return this.fExecutableField.getText();
    }

    public String getObjectName() {
        return this.fObjectField.getText();
    }

    public String getFileName() {
        return this.fFileField.getText();
    }

    public IMarker getMarker() {
        if (this.fExistingBP != null) {
            return this.fExistingBP.getMarker();
        }
        return null;
    }

    private void initializePage() {
        this.setPageComplete(false);
        if (this.fExistingBP == null) {
            ITextEditor editor;
            IWorkbenchPage p = CommonUtils.getActiveWorkbenchWindow().getActivePage();
            if (p != null && (editor = PICLDebugPlugin.getTextEditor((IWorkbenchPart)p.getActiveEditor())) != null) {
                int lineNumber = PICLUtils.getLineNumber((IEditorPart)editor);
                if (editor.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
                    EngineSuppliedViewEditorInput ei = (EngineSuppliedViewEditorInput)editor.getEditorInput();
                    ViewFile vf = ei.getViewFile();
                    this.fExecutableField.setText(vf.getPart().getModule().getName());
                    this.fObjectField.setText(vf.getPart().getName());
                    this.fFileField.setText(vf.getBaseFileName());
                    this.fLineNumberField.setText(String.valueOf(lineNumber));
                    return;
                }
            }
            if (this.getSettings() != null) {
                String text = this.getSettings().get(EXECUTABLE);
                if (text != null) {
                    this.fExecutableField.setText(text);
                }
                if ((text = this.getSettings().get(OBJECT)) != null) {
                    this.fObjectField.setText(text);
                }
                if ((text = this.getSettings().get(FILE)) != null) {
                    this.fFileField.setText(text);
                }
                if ((text = this.getSettings().get(LINE)) != null) {
                    this.fLineNumberField.setText(text);
                }
            }
        } else {
            String executableText = null;
            String objectText = null;
            String fileNameText = null;
            int lineNumber = 0;
            String userLabel = null;
            IMarker marker = this.fExistingBP.getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IWorkspaceRoot) {
                fileNameText = marker.getAttribute("fileName", "");
            } else if (resource instanceof IFile) {
                fileNameText = resource.getName();
            }
            lineNumber = marker.getAttribute("lineNumber", 0);
            executableText = marker.getAttribute("moduleName", "");
            objectText = marker.getAttribute("objectName", "");
            userLabel = marker.getAttribute("userLabel", "");
            if (userLabel.equals("!NULL!")) {
                userLabel = "";
            }
            this.fExecutableField.setText(executableText);
            this.fObjectField.setText(objectText);
            if (fileNameText == null) {
                this.fFileField.setText("");
            } else {
                this.fFileField.setText(fileNameText);
            }
            if (lineNumber > 0) {
                this.fLineNumberField.setText(String.valueOf(lineNumber));
            } else {
                this.fLineNumberField.setText("");
            }
            this.fUserLabelField.setText(userLabel);
        }
    }

    @Override
    public void writeSettings() {
        IDialogSettings settings = this.getSettings();
        if (settings == null) {
            this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        settings = this.getSettings();
        settings.put(EXECUTABLE, this.fExecutableField.getText());
        settings.put(OBJECT, this.fObjectField.getText());
        settings.put(FILE, this.fFileField.getText());
    }

    private IDialogSettings getSettings() {
        IDialogSettings ds = this.getDialogSettings();
        if (ds == null) {
            return null;
        }
        return ds.getSection(PAGE_NAME);
    }

    private String getObjectLabel() {
        return PICLLabels.LineBPWizard_page1_objectOptional;
    }

    private String getExecutableLabel() {
        return PICLLabels.LineBPWizard_page1_executableOptional;
    }

    private String getFileLabel() {
        return PICLLabels.LineBPWizard_page1_sourceLabel;
    }

    protected void checkIfComplete() {
        this.setErrorMessage(null);
        if (this.fFileField.getText().equals("") || this.fLineNumberField.getText().equals("")) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public String getUserLabel() {
        return this.fUserLabelField.getText();
    }
}

