/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class FindTextDialog
extends DebugStatusDialog {
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".findTextDialog";
    private Combo expressionInput;
    private Button caseSensitiveButton;
    private DebuggerEditor fEditor;
    private static final int MAX_HISTORY = 5;
    private static ArrayList<String> exprHistory = new ArrayList(5);

    public FindTextDialog(DebuggerEditor editor) {
        super(editor.getEditorSite().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PICLLabels.FindTextDialog_title);
        this.fEditor = editor;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParentShell(), PICLUtils.getHelpResourceString("find_text_dialog"));
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        spec.widthHint = 350;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)spec);
        Label expressionInputLabel = new Label(parent, 0);
        expressionInputLabel.setText(PICLLabels.FindTextDialog_text);
        this.expressionInput = new Combo(parent, 2048);
        spec = new GridData(768);
        spec.horizontalSpan = 2;
        this.expressionInput.setLayoutData((Object)spec);
        this.caseSensitiveButton = new Button(parent, 32);
        this.caseSensitiveButton.setText(PICLLabels.FindTextDialog_case);
        int i = 0;
        while (i < exprHistory.size()) {
            if (exprHistory.get(i) != null) {
                this.expressionInput.add(exprHistory.get(i));
            }
            ++i;
        }
        String editorText = null;
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        if (textSelection != null && textSelection.getText() != null && (editorText = textSelection.getText()) != null && !editorText.equals("") && editorText.indexOf(10) > 0) {
            editorText = editorText.substring(0, editorText.indexOf(10));
        }
        if (editorText != null) {
            this.expressionInput.setText(editorText);
        }
        this.expressionInput.setFocus();
        FindTextDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void okPressed() {
        String expression = this.expressionInput.getText();
        FindTextDialog.addExpressionHistory(expression);
        IEditorInput input = this.fEditor.getEditorInput();
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)this, "DebuggerEditor: trying to use debug Find Text dialog on a non-EngineSuppliedView");
            }
            return;
        }
        Location stringLocation = this.fEditor.findString(expression, this.caseSensitiveButton.getSelection(), false);
        if (stringLocation == null) {
            this.updateStatus((IStatus)new Status(1, PICLDebugPlugin.getPluginID(), 0, PICLMessages.FindTextDialog_error1, null));
            return;
        }
        this.fEditor.gotoLine(stringLocation.getLineNumber(), false);
        this.fEditor.hiliteWord(stringLocation.getLineNumber(), stringLocation.getColumnNumber(), expression.length());
        super.okPressed();
    }

    public static void addExpressionHistory(String expression) {
        if (!exprHistory.contains(expression)) {
            if (exprHistory.size() == 5) {
                exprHistory.remove(4);
            }
            exprHistory.add(0, expression);
        } else {
            int idx = exprHistory.indexOf(expression);
            if (idx != -1) {
                exprHistory.remove(idx);
                exprHistory.add(0, expression);
            }
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

