/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.EnhancedWatchpoint;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.EnhancedWatchBPWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.WorkbenchJob;

public class EnhancedWatchBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "EnhancedWatchBPWizard.dialog";
    protected static final String PAGE_1 = "EnhancedWatchBPWizard.page1";
    protected static final String PAGE_2 = "BreakpointWizard.optional";
    private EnhancedWatchpoint existingBP;

    public EnhancedWatchBPWizard(PDTDebugTarget debugTarget) {
        super(debugTarget);
        this.fEditing = false;
        this.existingBP = null;
        this.initializeWizard();
    }

    public EnhancedWatchBPWizard(PDTDebugTarget debugTarget, EnhancedWatchpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(PICLLabels.WatchBPWizard_dialog_title);
        } else {
            this.setWindowTitle(PICLLabels.WatchBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        this.setDialogSettings(this.getDialogSettings(DIALOG));
    }

    private IDialogSettings getDialogSettings(String dialogName) {
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(dialogName);
        if (section == null) {
            section = dialogSettings.addNewSection(dialogName);
        }
        return section;
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.WatchBPWizard_page1_pageName;
        this.addPage((IWizardPage)new EnhancedWatchBPWizardPage(this.fMainPageName, PICLLabels.WatchBPWizard_page1_title, null, this.fDebugTarget, this.existingBP));
        if (this.areOptionalParametersSupported()) {
            ConditionalBreakpointWizardPage condPage = new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP);
            condPage.setSupportsExpressionField(this.fDebugTarget.supportsExpressionOnConditionalBkp() && this.fDebugTarget.supportsChgAddrContionalBkp());
            this.addPage((IWizardPage)condPage);
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        EnhancedWatchBPWizardPage mainPage = (EnhancedWatchBPWizardPage)this.getPage(this.fMainPageName);
        ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        EStdView esv = mainPage.getEStdView();
        this.scheduleEReqJob(mainPage, condPage, esv);
        return false;
    }

    private void scheduleEReqJob(final EnhancedWatchBPWizardPage mainPage, final ConditionalBreakpointWizardPage condPage, final EStdView esv) {
        final EnhancedWatchBPWizardPage.PageData mainPageData = mainPage.getPageData();
        final OptionalBreakpointData condPageData = condPage.getPageData();
        condPageData.setUserLabel(mainPageData.userLabel);
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                final StatusInfo processResult = EnhancedWatchBPWizard.this.processBreakpoint(esv, mainPageData, condPageData);
                if (!condPage.getControl().isDisposed()) {
                    EnhancedWatchBPWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            EnhancedWatchBPWizard.this.updateWizardPostProcessing(processResult, mainPage, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    EnhancedWatchBPWizard.this.wbJob.setSystem(true);
                    EnhancedWatchBPWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private StatusInfo processBreakpoint(EStdView esv, EnhancedWatchBPWizardPage.PageData mainPageData, OptionalBreakpointData optData) {
        boolean usingWatchRange;
        StatusInfo status = new StatusInfo();
        boolean watchAddrOK = !PDTCoreUtils.isEmpty((String)mainPageData.watchAddr) || !PDTCoreUtils.isEmpty((String)mainPageData.watchReg);
        boolean watchBytesOK = mainPageData.numBytes >= -1;
        boolean bl = usingWatchRange = !PDTCoreUtils.isEmpty((String)mainPageData.rangeFrom) || !PDTCoreUtils.isEmpty((String)mainPageData.rangeTo);
        if (!watchAddrOK) {
            status.setError(PICLMessages.WatchBPWizard_page1_addressError);
            return status;
        }
        if (!watchBytesOK) {
            status.setError(PICLMessages.WatchBPWizard_page1_bytesError);
            return status;
        }
        if (usingWatchRange) {
            long toAddr;
            long fromAddr;
            String fromLabel = PICLLabels.EnhancedWatchBPWizard_page1_FromLabel;
            String toLabel = PICLLabels.EnhancedWatchBPWizard_page1_ToLabel;
            try {
                fromAddr = PDTCoreUtils.getAddress((String)mainPageData.rangeFrom);
            }
            catch (NumberFormatException nfe) {
                status.setError(NLS.bind((String)PICLMessages.EnhancedWatchBPWizard_page1_NaNFromStringError, (Object)fromLabel));
                return status;
            }
            try {
                toAddr = PDTCoreUtils.getAddress((String)mainPageData.rangeTo);
            }
            catch (NumberFormatException nfe) {
                status.setError(NLS.bind((String)PICLMessages.EnhancedWatchBPWizard_page1_NaNFromStringError, (Object)toLabel));
                return status;
            }
            if (fromAddr > toAddr) {
                status.setError(NLS.bind((String)PICLMessages.EnhancedWatchBPWizard_page1_InvalidRangeError, (Object)fromAddr, (Object)toAddr));
                return status;
            }
        } else if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        try {
            if (!this.fEditing) {
                ((DebuggeeProcess)this.fDebugTarget.getProcess()).setEnhancedWatchpoint(true, mainPageData.watchAddr, mainPageData.watchReg, mainPageData.numBytes, mainPageData.equalCond, mainPageData.rangeMod, mainPageData.rangeObj, mainPageData.rangeFrom, mainPageData.rangeTo, optData, null, esv);
            } else {
                this.existingBP.modify(mainPageData.watchAddr, mainPageData.watchReg, mainPageData.numBytes, mainPageData.equalCond, mainPageData.rangeMod, mainPageData.rangeObj, mainPageData.rangeFrom, mainPageData.rangeTo, optData, esv);
            }
        }
        catch (EngineRequestErrorException ere) {
            if (ere.getReturnCode() == 323) {
                status.setWarning(ere.getMessage());
            } else {
                status.setError(ere.getMessage());
            }
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

