/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.ProfileItem;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import com.ibm.debug.pdt.internal.ui.util.CheckedList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class DeleteProfileDialog
extends DebugTrayDialog {
    protected CheckedList fProfileListControl;
    private ProfileItem[] fProfileList;
    private Button fCheckAllButton;
    private Button fUncheckAllButton;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".deleteProfileDialog";
    private static final String XMLFILEEXT = ".xml";
    private static final String DOTAT = String.valueOf('.') + "@";

    public DeleteProfileDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PICLLabels.PICLDebugProfileDeleteDialog_Title);
    }

    protected Control createDialogArea(Composite ancestor) {
        Label l = new Label(ancestor, 0);
        l.setText(PICLLabels.PICLDebugProfileDeleteDialog_SearchFieldLabel);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(65);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        this.fProfileListControl = new CheckedList(ancestor, true, false, false);
        this.fProfileListControl.setLayoutData(gd);
        this.initializeProfileList();
        Composite buttonParent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonParent.setLayout((Layout)layout);
        this.fCheckAllButton = new Button(buttonParent, 8);
        this.fCheckAllButton.setText(PICLLabels.AddExceptionDialog_checkAllButton);
        this.fCheckAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeleteProfileDialog.this.fProfileListControl.checkAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fUncheckAllButton = new Button(buttonParent, 8);
        this.fUncheckAllButton.setText(PICLLabels.AddExceptionDialog_uncheckAllButton);
        this.fUncheckAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeleteProfileDialog.this.fProfileListControl.uncheckAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), PICLUtils.getHelpResourceString("delte_profile_dialog"));
        this.fProfileListControl.selectFilterText();
        Dialog.applyDialogFont((Control)ancestor);
        return ancestor;
    }

    private void initializeProfileList() {
        File profileDir = new File(PDTCoreUtils.getProfileSaveRestoreLocation());
        File[] files = profileDir.listFiles();
        if (files == null) {
            return;
        }
        HashMap<String, ProfileItem> profileMap = new HashMap<String, ProfileItem>();
        ArrayList<ProfileItem> profileList = new ArrayList<ProfileItem>();
        ArrayList<ProfileItem> programProfileList = new ArrayList<ProfileItem>();
        String atString = String.valueOf('@');
        int i = 0;
        while (i < files.length) {
            String fileName = files[i].getName();
            String key = fileName.endsWith(XMLFILEEXT) ? fileName.substring(0, fileName.indexOf(46, fileName.indexOf(64))) : fileName.replace(DOTAT, atString);
            if (profileMap.containsKey(key)) {
                ((ProfileItem)profileMap.remove(key)).addSecondFile(files[i]);
            } else {
                ProfileItem item = new ProfileItem(files[i]);
                profileMap.put(key, item);
                if (item.isGlobalProfile()) {
                    profileList.add(item);
                } else {
                    programProfileList.add(item);
                }
            }
            ++i;
        }
        IEclipsePreferences preference = ConfigurationScope.INSTANCE.getNode("com.ibm.debug.pdt.core/exceptionsDefault");
        if (preference != null) {
            try {
                String[] keys;
                String[] stringArray = keys = preference.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefKey = stringArray[n2];
                    ProfileItem item = new ProfileItem(preference, prefKey);
                    profileList.add(item);
                    ++n2;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        if (profileList.isEmpty() && programProfileList.isEmpty()) {
            return;
        }
        if (!profileList.isEmpty()) {
            Collections.sort(profileList);
        }
        if (!programProfileList.isEmpty()) {
            Collections.sort(programProfileList);
            profileList.addAll(programProfileList);
        }
        this.fProfileList = profileList.toArray(new ProfileItem[profileList.size()]);
        this.fProfileListControl.setElements(this.fProfileList);
        this.fProfileListControl.setFilter("*", true);
    }

    protected void okPressed() {
        if (this.fProfileList != null) {
            int i = 0;
            while (i < this.fProfileList.length) {
                this.fProfileList[i].process();
                ++i;
            }
        }
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

