/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.Module;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class BreakpointWizardPage
extends WizardPage {
    protected PDTDebugTarget fDebugTarget = null;
    private static final String[] EMPTYSTRINGS = new String[0];
    boolean fEditing = false;
    protected Part[] fParts;

    protected BreakpointWizardPage(String pageName, String title, ImageDescriptor titleImage, PDTDebugTarget tgt, boolean edit) {
        super(pageName, title, titleImage);
        this.fDebugTarget = tgt;
        this.fEditing = edit;
    }

    protected void fillExecutables(Combo field, boolean filter) {
        Object[] modules = ((DebuggeeProcess)this.fDebugTarget.getProcess()).getModules(filter);
        if (modules.length == 0) {
            if (field != null) {
                field.setItems(new String[0]);
            }
            return;
        }
        Arrays.sort(modules);
        if (field != null) {
            String[] returnList = new String[modules.length];
            int j = 0;
            while (j < returnList.length) {
                returnList[j] = modules[j].getLabel();
                ++j;
            }
            field.setItems(returnList);
        }
    }

    protected void fillObjects(Combo field, boolean filter, String chosenModule) {
        Module[] modules = ((DebuggeeProcess)this.fDebugTarget.getProcess()).getModules(filter);
        Module module = null;
        int i = 0;
        while (i < modules.length) {
            Module mod = modules[i];
            if (mod.getName().equalsIgnoreCase(chosenModule)) {
                module = mod;
                break;
            }
            ++i;
        }
        if (module == null) {
            if (field != null) {
                field.removeAll();
            }
            return;
        }
        this.fParts = module.getParts(filter);
        if (this.fParts.length == 0) {
            if (field != null) {
                field.removeAll();
            }
            return;
        }
        Arrays.sort(this.fParts);
        if (field != null) {
            String[] returnList = new String[this.fParts.length];
            int j = 0;
            while (j < returnList.length) {
                returnList[j] = this.fParts[j].getLabel();
                ++j;
            }
            field.setItems(returnList);
        }
    }

    protected ViewFile getViewFile() {
        ITextEditor editor = PICLDebugPlugin.getActiveTextEditor();
        if (editor == null) {
            DebuggeeThread stoppingThread = this.fDebugTarget.getStoppingThread();
            if (stoppingThread == null) {
                return null;
            }
            Location loc = stoppingThread.getLocation();
            return loc == null ? null : loc.getViewFile();
        }
        return PICLUtils.getViewFile(editor.getEditorInput());
    }

    protected String[] filter(String[] fieldItems, String fieldText) {
        ArrayList<String> filteredItems = new ArrayList<String>();
        String filterText = fieldText;
        filterText = filterText.replaceAll("\\*", ".*");
        filterText = filterText.replaceAll("\\?", ".");
        filterText = filterText.replaceAll("\\(", "\\\\(");
        filterText = filterText.replaceAll("\\)", "\\\\)");
        filterText = filterText.replaceAll("\\[", "\\\\[");
        filterText = filterText.replaceAll("\\]", "\\\\]");
        String regex = filterText + ".*";
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex, 2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (pattern != null) {
            Matcher matcher = null;
            int i = 0;
            while (i < fieldItems.length) {
                matcher = pattern.matcher(fieldItems[i]);
                if (matcher.matches()) {
                    filteredItems.add(fieldItems[i]);
                }
                ++i;
            }
        }
        if (filteredItems.isEmpty()) {
            return EMPTYSTRINGS;
        }
        return filteredItems.toArray(new String[filteredItems.size()]);
    }
}

