/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.AddressRangeBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.AddressBPWizardPage;
import com.ibm.debug.pdt.internal.ui.dialogs.BreakpointWizard;
import com.ibm.debug.pdt.internal.ui.dialogs.ConditionalBreakpointWizardPage;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class AddressBPWizard
extends BreakpointWizard {
    protected static final String DIALOG = "AddressBPWizard.dialog";
    private AddressBreakpoint existingBP;
    private boolean fIsRange = false;

    public AddressBPWizard(PDTDebugTarget debugTarget) {
        this(debugTarget, false);
    }

    public AddressBPWizard(PDTDebugTarget debugTarget, boolean isRange) {
        super(debugTarget);
        this.fEditing = false;
        this.fIsRange = isRange;
        this.existingBP = null;
        this.initializeWizard();
    }

    public AddressBPWizard(PDTDebugTarget debugTarget, AddressBreakpoint breakpoint) {
        super(debugTarget);
        this.fEditing = true;
        this.fIsRange = breakpoint instanceof AddressRangeBreakpoint;
        this.existingBP = breakpoint;
        this.initializeWizard();
    }

    private void initializeWizard() {
        if (!this.fEditing) {
            this.setWindowTitle(this.fIsRange ? PICLLabels.AddressRangeBPWizard_dialog_title : PICLLabels.AddressBPWizard_dialog_title);
        } else {
            this.setWindowTitle(this.fIsRange ? PICLLabels.AddressRangeBPWizard_dialog_title2 : PICLLabels.AddressBPWizard_dialog_title2);
        }
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_BREAKPOINT_WIZARD"));
        this.setNeedsProgressMonitor(false);
        IDialogSettings dialogSettings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(DIALOG);
        if (section == null) {
            section = dialogSettings.addNewSection(DIALOG);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.fMainPageName = PICLLabels.AddressBPWizard_page1_pageName;
        this.addPage((IWizardPage)new AddressBPWizardPage(this.fMainPageName, PICLLabels.AddressBPWizard_page1_title, null, this.existingBP, this.fIsRange));
        if (this.areOptionalParametersSupported()) {
            this.addPage((IWizardPage)new ConditionalBreakpointWizardPage(this.fCondPageName, PICLLabels.BreakpointWizard_optional_title, null, this.fDebugTarget, (Breakpoint)this.existingBP));
        }
    }

    @Override
    public boolean performFinish() {
        if (this.checkFinishButtonClicked()) {
            return false;
        }
        final AddressBPWizardPage page = (AddressBPWizardPage)this.getPage(this.fMainPageName);
        final ConditionalBreakpointWizardPage condPage = this.areOptionalParametersSupported() ? (ConditionalBreakpointWizardPage)this.getPage(this.fCondPageName) : new ConditionalBreakpointWizardPage("", "", null, this.fDebugTarget, (Breakpoint)this.existingBP);
        final String address = page.getAddress();
        final OptionalBreakpointData optData = condPage.getPageData();
        optData.setUserLabel(page.getUserLabel());
        Job job = new Job(PICLLabels.BreakpointWizard_jobname_CreateModify){

            protected IStatus run(IProgressMonitor monitor) {
                StatusInfo created;
                final StatusInfo processResult = created = AddressBPWizard.this.processBreakpoint(address, optData);
                if (!page.getControl().isDisposed()) {
                    AddressBPWizard.this.wbJob = new WorkbenchJob(PICLLabels.BreakpointWizard_jobname_Update){

                        public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                            AddressBPWizard.this.updateWizardPostProcessing(processResult, page, condPage);
                            return Status.OK_STATUS;
                        }
                    };
                    AddressBPWizard.this.wbJob.setSystem(true);
                    AddressBPWizard.this.wbJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return false;
    }

    private StatusInfo processBreakpoint(String address, OptionalBreakpointData optData) {
        StatusInfo status = new StatusInfo();
        if (address == null || address.equals("")) {
            status.setError(PICLMessages.AddressBPWizard_page1_addressError);
            return status;
        }
        if (this.fDebugTarget == null) {
            status.setError(PICLMessages.BreakpointWizard_targetError);
            return status;
        }
        Location loc = null;
        try {
            DebuggeeThread t = this.fDebugTarget.getStoppingThread();
            loc = t.getLocation();
        }
        catch (NullPointerException npe) {
            status.setError(PICLMessages.AddressBPWizard_page1_locationError);
            return status;
        }
        try {
            if (!this.fEditing) {
                ((DebuggeeProcess)this.fDebugTarget.getProcess()).setAddressBreakpoint(true, address, loc, optData, null, this.fIsRange);
            } else {
                this.existingBP.modify(address, loc, optData);
            }
        }
        catch (EngineRequestErrorException ere) {
            status.setError(ere.getMessage());
        }
        catch (EngineRequestException engineRequestException) {
            // empty catch block
        }
        return status;
    }
}

