/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.dialogs;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugStatusDialog;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddProgramDialog
extends DebugStatusDialog {
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".addProgramDialog";
    private PDTDebugTarget fdt;
    protected Combo fProgramNamefield;
    private Button fProgramButton;
    private Button fServicePgmButton;
    private Button fJavaClassButton;
    private static final int MAX_HISTORY = 5;
    private static ArrayList<String> progHistory = new ArrayList(5);
    private int fPgmType;

    public AddProgramDialog(Shell parent, PDTDebugTarget dt) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fdt = dt;
        this.setTitle(PICLLabels.AddProgramDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PICLUtils.getHelpResourceString("add_program_dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Label label = new Label(comp, 0);
        label.setLayoutData((Object)new GridData(256));
        label.setText(PICLLabels.AddProgramDialog_program_name);
        this.fProgramNamefield = new Combo(comp, 2048);
        this.fProgramNamefield.setLayoutData((Object)new GridData(256));
        Group pgmTypeGrp = new Group(comp, 0);
        pgmTypeGrp.setLayout((Layout)new GridLayout());
        pgmTypeGrp.setText(PICLLabels.AddProgramDialog_program_type);
        pgmTypeGrp.setLayoutData((Object)new GridData(256));
        this.fProgramButton = new Button((Composite)pgmTypeGrp, 16);
        this.fProgramButton.setText(PICLLabels.AddProgramDialog_program_type_program);
        this.fProgramButton.setSelection(true);
        this.fServicePgmButton = new Button((Composite)pgmTypeGrp, 16);
        this.fServicePgmButton.setText(PICLLabels.AddProgramDialog_program_type_service_program);
        this.fJavaClassButton = new Button((Composite)pgmTypeGrp, 16);
        this.fJavaClassButton.setText(PICLLabels.AddProgramDialog_program_type_java_class);
        int i = 0;
        while (i < progHistory.size()) {
            if (progHistory.get(i) != null) {
                this.fProgramNamefield.add(progHistory.get(i));
            }
            ++i;
        }
        this.fProgramNamefield.setFocus();
        this.fProgramNamefield.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddProgramDialog.this.fProgramNamefield.getText().length() > 0) {
                    AddProgramDialog.this.getButton(0).setEnabled(true);
                } else {
                    AddProgramDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        AddProgramDialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected void okPressed() {
        this.fPgmType = 0;
        if (this.fdt != null) {
            this.fPgmType = 0;
            if (this.fProgramButton.getSelection()) {
                this.fPgmType = 0;
            } else if (this.fServicePgmButton.getSelection()) {
                this.fPgmType = 1;
            } else if (this.fJavaClassButton.getSelection()) {
                this.fPgmType = 2;
            }
            Job job = new Job("Add Program"){
                String progName;
                {
                    this.progName = AddProgramDialog.this.fProgramNamefield.getText();
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        AddProgramDialog.this.fdt.getDebugEngine().addProgram(this.progName, AddProgramDialog.this.fPgmType);
                    }
                    catch (EngineRequestException e) {
                        PICLDebugPlugin.showMessageDialog(AddProgramDialog.this.getShell(), e.getMessage(), true);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            AddProgramDialog.addProgHistory(this.fProgramNamefield.getText());
        }
        super.okPressed();
    }

    private static void addProgHistory(String prog) {
        if (!progHistory.contains(prog)) {
            if (progHistory.size() == 5) {
                progHistory.remove(4);
            }
            progHistory.add(0, prog);
        } else {
            int idx = progHistory.indexOf(prog);
            if (idx != -1) {
                progHistory.remove(idx);
                progHistory.add(0, prog);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control ctrl = super.createButtonBar(parent);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
        return ctrl;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

