/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.contentassist;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.contentassist.ContentAssistTextContentAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;

public class ContentAssistProvider {
    private static final String[] EMPTYSTRING = new String[0];
    private static final String ASSISTDIRECTORY = "contentassist/";
    private static final String DEBUG_TOOL = "DEBUG_TOOL";
    private static final String ZOS_DEBUGGER = "Z/OS_DEBUGGER";
    private static final String DEBUG_TOOL_DEFAULT = "DEBUG_TOOL_DEFAULT";
    private static final String ASSISTFILEEXTENSION = ".txt";
    private static final String ASSISTFILESEPARATOR = "_";
    private SimpleContentProposalProvider fContentProposalProvider;

    public ContentAssistProvider(Control control) {
        this(control, KeyStroke.getInstance((int)262144, (int)32), true);
    }

    public ContentAssistProvider(Control control, KeyStroke keyStroke, boolean filtering) {
        Object controlContentAdapter = control instanceof Combo ? new ComboContentAdapter() : new ContentAssistTextContentAdapter();
        this.fContentProposalProvider = new SimpleContentProposalProvider(EMPTYSTRING);
        this.fContentProposalProvider.setFiltering(filtering);
        ContentProposalAdapter contentAdapter = new ContentProposalAdapter(control, (IControlContentAdapter)controlContentAdapter, (IContentProposalProvider)this.fContentProposalProvider, keyStroke, null);
        contentAdapter.setProposalAcceptanceStyle(2);
    }

    public void setProposals(String[] proposals) {
        this.fContentProposalProvider.setProposals(proposals);
    }

    public String[] getProposals(String engineVersion, String qualifier) {
        block24: {
            StringBuilder assistFileName;
            Bundle fragmentBundle;
            block25: {
                if (engineVersion == null) {
                    return EMPTYSTRING;
                }
                engineVersion = engineVersion.replace(' ', '_').toUpperCase();
                fragmentBundle = Platform.getBundle((String)PICLDebugPlugin.getPluginID());
                if (fragmentBundle == null) {
                    return EMPTYSTRING;
                }
                assistFileName = new StringBuilder();
                assistFileName.append(ASSISTDIRECTORY);
                assistFileName.append(engineVersion);
                if (qualifier != null) {
                    assistFileName.append(qualifier);
                }
                assistFileName.append(ASSISTFILEEXTENSION);
                try {
                    return this.parseCommands(assistFileName.toString(), fragmentBundle);
                }
                catch (Exception exception) {
                    assistFileName.setLength(0);
                    assistFileName.append(ASSISTDIRECTORY);
                    if (!engineVersion.startsWith(DEBUG_TOOL) && !engineVersion.startsWith(ZOS_DEBUGGER)) break block24;
                    assistFileName.append(DEBUG_TOOL);
                    StringTokenizer tokens = new StringTokenizer(engineVersion, ASSISTFILESEPARATOR);
                    String version = null;
                    if (tokens.countTokens() <= 2) break block25;
                    tokens.nextToken();
                    tokens.nextToken();
                    version = tokens.nextToken();
                    assistFileName.append(ASSISTFILESEPARATOR).append(version);
                    if (qualifier != null) {
                        assistFileName.append(qualifier);
                    }
                    assistFileName.append(ASSISTFILEEXTENSION);
                    try {
                        return this.parseCommands(assistFileName.toString(), fragmentBundle);
                    }
                    catch (Exception exception2) {
                        int last2;
                        int vIdx = version.lastIndexOf(77);
                        if (vIdx > -1) {
                            assistFileName.setLength(0);
                            assistFileName.append(ASSISTDIRECTORY);
                            assistFileName.append(DEBUG_TOOL);
                            assistFileName.append(ASSISTFILESEPARATOR).append(version.substring(0, vIdx));
                            if (qualifier != null) {
                                assistFileName.append(qualifier);
                            }
                            assistFileName.append(ASSISTFILEEXTENSION);
                        } else if (version.matches("[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*") && (last2 = version.lastIndexOf(".")) > 0) {
                            version = version.substring(0, last2);
                            assistFileName.setLength(0);
                            assistFileName.append(ASSISTDIRECTORY);
                            assistFileName.append(DEBUG_TOOL);
                            assistFileName.append(ASSISTFILESEPARATOR).append(version);
                            if (qualifier != null) {
                                assistFileName.append(qualifier);
                            }
                            assistFileName.append(ASSISTFILEEXTENSION);
                        }
                        try {
                            return this.parseCommands(assistFileName.toString(), fragmentBundle);
                        }
                        catch (Exception last2) {
                            int lastDot = version.lastIndexOf(46);
                            if (lastDot <= -1) break block25;
                            try {
                                int mod = Integer.parseInt(version.substring(lastDot + 1));
                                while (--mod >= 0) {
                                    assistFileName.setLength(0);
                                    assistFileName.append(ASSISTDIRECTORY).append(DEBUG_TOOL);
                                    assistFileName.append(ASSISTFILESEPARATOR).append(version.substring(0, lastDot + 1));
                                    assistFileName.append(mod);
                                    if (qualifier != null) {
                                        assistFileName.append(qualifier);
                                    }
                                    assistFileName.append(ASSISTFILEEXTENSION);
                                    try {
                                        return this.parseCommands(assistFileName.toString(), fragmentBundle);
                                    }
                                    catch (Exception exception3) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            assistFileName.setLength(0);
            assistFileName.append(ASSISTDIRECTORY);
            assistFileName.append(DEBUG_TOOL_DEFAULT);
            if (qualifier != null) {
                assistFileName.append(qualifier);
            }
            assistFileName.append(ASSISTFILEEXTENSION);
            try {
                return this.parseCommands(assistFileName.toString(), fragmentBundle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return EMPTYSTRING;
    }

    private String[] parseCommands(String assistFile, Bundle fragmentBundle) throws Exception {
        Path path = new Path(assistFile);
        URL fileLocation = FileLocator.find((Bundle)fragmentBundle, (IPath)path, null);
        if (fileLocation == null) {
            throw new Exception();
        }
        InputStream input = null;
        input = fileLocation.openStream();
        BufferedReader buf = new BufferedReader(new InputStreamReader(input));
        ArrayList<String> commands = new ArrayList<String>();
        try {
            while (buf.ready()) {
                commands.add(buf.readLine());
            }
        }
        finally {
            try {
                buf.close();
            }
            catch (IOException iOException) {}
        }
        return commands.toArray(new String[commands.size()]);
    }
}

