/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.breakpoints.PICLBaseBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLZeroAddressBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public class ZeroAddressBreakpointAction
extends Action {
    private PDTDebugTarget fDebugTarget;
    private IAction fDelegatedAction = null;

    public ZeroAddressBreakpointAction(IAction action, PDTDebugTarget debugTarget) {
        this.fDelegatedAction = action;
        this.fDebugTarget = debugTarget;
        this.setText(PICLLabels.StopAtZeroAddresses);
        PICLZeroAddressBreakpoint bkp = this.fDebugTarget.findZeroAddressBreakpoint();
        boolean state = false;
        try {
            if (bkp != null && bkp.isEnabled()) {
                state = true;
            }
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        this.setChecked(state);
        this.setEnabled(this.fDebugTarget.isAcceptingRequests());
        if (this.fDelegatedAction != null) {
            this.fDelegatedAction.setText(PICLLabels.StopAtZeroAddresses);
            this.fDelegatedAction.setEnabled(this.isEnabled());
            this.fDelegatedAction.setChecked(this.isChecked());
        }
    }

    public ZeroAddressBreakpointAction(PDTDebugTarget debugTarget, boolean enabled) {
        this.initialize(debugTarget, enabled);
    }

    public void run() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches == null) {
            return;
        }
        boolean delay = false;
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            IDebugTarget[] targets = l.getDebugTargets();
            if (targets != null) {
                IDebugTarget[] iDebugTargetArray = targets;
                int n3 = targets.length;
                int n4 = 0;
                while (n4 < n3) {
                    PICLDebugTarget dbgtgt;
                    IDebugTarget t = iDebugTargetArray[n4];
                    if (t instanceof PICLDebugTarget && (dbgtgt = (PICLDebugTarget)t).isAcceptingRequests() && dbgtgt.supportsZeroAddressBreakpoints()) {
                        this.scheduleBreakpoint(dbgtgt, delay);
                        delay = true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void scheduleBreakpoint(final PICLDebugTarget dbgtgt, boolean delay) {
        new Job("Set zero address breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                PICLZeroAddressBreakpoint bkp = dbgtgt.findZeroAddressBreakpoint();
                try {
                    if (bkp == null) {
                        dbgtgt.createZeroAddressBreakpoint(true, new OptionalBreakpointData(), null);
                    } else if (!bkp.isEnabled()) {
                        bkp.setEnabled(true);
                    } else {
                        bkp.delete();
                    }
                }
                catch (CoreException coreException) {
                }
                catch (EngineRequestException e) {
                    PICLUtils.logError((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initialize(PDTDebugTarget target, boolean enabled) {
        this.setChecked((PICLBaseBreakpoint)target.findZeroAddressBreakpoint());
        this.setText(PICLLabels.StopAtZeroAddresses);
        this.setId("com.ibm.debug.pdt.core.PICLZeroAddressBreakpoint");
        this.setEnabled(enabled);
    }

    private void setChecked(PICLBaseBreakpoint breakpoint) {
        try {
            this.setChecked(breakpoint != null && breakpoint.isEnabled());
        }
        catch (CoreException e) {
            this.setChecked(false);
        }
    }
}

