/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.breakpoints.PICLWatchBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.EditorToggleBreakpointAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapterAction
implements IToggleBreakpointsTarget {
    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return PICLDebugPlugin.getTextEditor(part) != null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor editor = PICLDebugPlugin.getTextEditor(part);
        if (editor != null) {
            EditorToggleBreakpointAction editorAction = new EditorToggleBreakpointAction(editor, selection, null, null, false, false);
            editorAction.run();
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return PICLDebugPlugin.getTextEditor(part) != null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor editor = PICLDebugPlugin.getActiveTextEditor();
        ViewFile viewFile = PICLDebugPlugin.getViewFile(editor);
        int lineNumber = -1;
        lineNumber = PICLUtils.getLineNumber((IEditorPart)editor);
        Function thisMethod = null;
        if (viewFile != null && lineNumber > 0) {
            Function[] functions = viewFile.getFunctions(lineNumber);
            thisMethod = functions[0];
        }
        if (thisMethod != null) {
            try {
                thisMethod.toggleBreakpoint();
            }
            catch (EngineRequestException e) {
                PICLUtils.logError((Exception)((Object)e));
            }
        }
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        String expression = PICLUtils.getAddrOrExprFromActiveEditor();
        ViewFile viewFile = PICLDebugPlugin.getViewFile(PICLDebugPlugin.getActiveTextEditor());
        IDebugTarget target = viewFile.getDebugTarget();
        if (expression != null && expression.trim().length() > 0) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
            IBreakpoint foundBreakpoint = null;
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof PICLWatchBreakpoint) {
                    PICLWatchBreakpoint thisWatchBreakpoint = (PICLWatchBreakpoint)breakpoints[i];
                    String expressionForThisBP = thisWatchBreakpoint.getExpression();
                    PDTDebugTarget thisDebugTarget = thisWatchBreakpoint.getDebugTarget();
                    if (expressionForThisBP.equals(expression) && target == thisDebugTarget) {
                        foundBreakpoint = breakpoints[i];
                        break;
                    }
                }
                ++i;
            }
            if (foundBreakpoint == null) {
                if (target instanceof PDTDebugTarget) {
                    PDTDebugTarget pdtDebugTarget = (PDTDebugTarget)target;
                    EStdView esv = PICLUtils.getEStdViewForActiveEditor(pdtDebugTarget);
                    try {
                        ((DebuggeeProcess)target.getProcess()).setWatchpoint(false, true, expression, 0, new OptionalBreakpointData(), null, esv, null, null, null, null);
                    }
                    catch (EngineRequestErrorException engineRequestErrorException) {
                    }
                    catch (EngineRequestException engineRequestException) {}
                }
            } else {
                breakpointManager.removeBreakpoint(foundBreakpoint, true);
            }
        }
    }
}

