/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SortVariablesAction
implements IViewActionDelegate,
IDebugContextListener {
    private IViewPart fView;
    private IAction fAction;

    public void init(IViewPart view) {
        this.fView = view;
        PDTCorePlugin.setSortLocals((boolean)PreferenceUI.isLocalsSort());
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public void run(IAction action) {
        boolean checked = action.isChecked();
        PreferenceUI.setLocalsSort(checked);
        PDTCorePlugin.setSortLocals((boolean)checked);
        if (this.fView != null && this.fView instanceof AbstractDebugView) {
            Viewer thisViewer = ((AbstractDebugView)this.fView).getViewer();
            thisViewer.refresh();
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection selection = event.getContext();
        this.fAction.setEnabled(PICLDebugPlugin.getIPDTDebugTarget(selection) != null);
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.fAction = action;
        action.setChecked(PDTCorePlugin.isSortLocals());
    }
}

