/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RemoveVariableFromMonitorAction
extends SelectionProviderAction {
    public RemoveVariableFromMonitorAction(ISelectionProvider provider) {
        super(provider, PICLLabels.RemoveVariableFromMonitorAction_label);
        this.setToolTipText(PICLLabels.RemoveVariableFromMonitorAction_tooltip);
        this.setEnabled(!this.getStructuredSelection().isEmpty());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("remove_variable_from_monitor_action"));
    }

    public void run() {
        final IStructuredSelection selections = this.getStructuredSelection();
        if (selections.isEmpty()) {
            return;
        }
        new Job("Remove Monitor"){

            protected IStatus run(IProgressMonitor monitor) {
                Object[] objectArray = selections.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object var = objectArray[n2];
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (var instanceof ExprNodeBase) {
                        try {
                            ((ExprNodeBase)var).getExpression().remove();
                        }
                        catch (EngineRequestException e) {
                            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void selectionChanged(IStructuredSelection sel) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("remove_variable_from_monitor_action"));
        this.setChecked(false);
        this.setEnabled(!sel.isEmpty());
        Iterator iter = sel.iterator();
        Object object = null;
        while (iter.hasNext()) {
            object = iter.next();
            if (object instanceof ExprNodeBase) continue;
            this.setEnabled(false);
        }
    }
}

