/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class RemoveProgramAction
extends Action {
    private TreeViewer fTreeViewer;

    public RemoveProgramAction(TreeViewer treeViewer) {
        super(PICLLabels.RemoveProgramAction_label);
        this.fTreeViewer = treeViewer;
        this.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_COLLAPSE_ALL"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("remove_program_action"));
    }

    public void run() {
        StructuredSelection sel = (StructuredSelection)this.fTreeViewer.getSelection();
        if (sel != StructuredSelection.EMPTY && sel.size() == 1 && sel.getFirstElement() instanceof PICLModule) {
            final PICLModule module = (PICLModule)sel.getFirstElement();
            Job job = new Job("Remove Program Action"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ((PDTDebugTarget)module.getDebugTarget()).getDebugEngine().removeProgram(module.getModule());
                    }
                    catch (EngineRequestException e) {
                        PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }
}

