/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class PrintTableViewAction
extends Action {
    protected static final String PREFIX = "PrintViewAction.";
    protected TableViewer fViewer;
    protected String printJobTitle;

    public PrintTableViewAction(TableViewer viewer, String pJobTitle) {
        super(PICLLabels.PrintViewAction_label);
        this.setToolTipText(PICLLabels.PrintViewAction_tooltip);
        this.fViewer = viewer;
        this.printJobTitle = pJobTitle;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("print_view_action"));
    }

    private void printTable(TableItem[] itemList, GC printGC, Printer printer) {
        StringBuilder tableContents = new StringBuilder();
        int numColumns = ((Table)this.fViewer.getControl()).getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        TableColumn[] columns = ((Table)this.fViewer.getControl()).getColumns();
        int lineNum = 1;
        int k = 0;
        while (k < numColumns) {
            tableContents.append("  ");
            tableContents.append(columns[k].getText());
            ++k;
        }
        printGC.drawString(tableContents.toString(), 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
        int i = 0;
        while (i < itemList.length) {
            tableContents = new StringBuilder();
            int j = 0;
            while (j < numColumns) {
                tableContents.append("  ");
                tableContents.append(labelProvider.getColumnText(itemList[i].getData(), j));
                ++j;
            }
            printGC.drawString(tableContents.toString(), 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
            if (20 + ++lineNum * printGC.getFontMetrics().getHeight() > printer.getClientArea().height) {
                lineNum = 0;
                printer.endPage();
                printer.startPage();
                int k2 = 0;
                while (k2 < numColumns) {
                    tableContents.append(columns[k2].getText());
                    ++k2;
                }
                printGC.drawString(tableContents.toString(), 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
            }
            ++i;
        }
    }

    public void run() {
        PrintDialog printDialog = new PrintDialog(this.fViewer.getControl().getDisplay().getActiveShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            this.setChecked(false);
            return;
        }
        Printer printer = new Printer(printerData);
        GC gc = new GC((Drawable)printer);
        TableItem[] tableItems = ((Table)this.fViewer.getControl()).getItems();
        printer.startJob(this.printJobTitle);
        printer.startPage();
        this.printTable(tableItems, gc, printer);
        printer.endPage();
        printer.endJob();
        gc.dispose();
        printer.dispose();
        this.setChecked(false);
    }
}

