/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.actions.SelectionProviderAction;

public class MonitorNodeExpressionAction
extends SelectionProviderAction {
    public MonitorNodeExpressionAction(Viewer viewer) {
        super((ISelectionProvider)viewer, PICLLabels.AddSnippetToMonitorAction_label2);
    }

    public void run() {
        final IStructuredSelection selection = this.getStructuredSelection();
        Job monitorNodeJob = new Job("Monitor Node"){

            protected IStatus run(IProgressMonitor monitor) {
                Iterator iter = selection.iterator();
                ExprNodeBase node = null;
                IdentifierParser parser = null;
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ExprNodeBase)) continue;
                    node = (ExprNodeBase)obj;
                    try {
                        String nodeExpression = node.getNodeExpression(false);
                        try {
                            Location location = node.getExpression().getLocation();
                            parser = location.getViewFile().getPart().getLanguage().getIdentifierParser();
                            if (parser != null) {
                                nodeExpression = parser.doLanguageSpecifics(nodeExpression, nodeExpression, 0);
                            }
                        }
                        catch (NullPointerException location) {
                            // empty catch block
                        }
                        node.getDebugEngine().getProcess().monitorExpression(node.getExpression().getLocation().getEStdView(), node.getExpression().getThreadID(), nodeExpression, node.getExpression().isEnabled() ? (byte)-128 : 0, (short)0, null, null, null, null);
                    }
                    catch (EngineRequestException e) {
                        PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        monitorNodeJob.schedule();
    }

    public void selectionChanged(IStructuredSelection sel) {
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof ExprNodeBase)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(true);
    }
}

