/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.actions.AbstractEditorActionDelegate;
import com.ibm.debug.pdt.internal.ui.memory.MapStorageAction;
import com.ibm.debug.pdt.internal.ui.memory.MonitorMemoryMenuManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class MonitorMemoryEditorActionDelegate
extends AbstractEditorActionDelegate {
    private MonitorMemoryMenuManager fStorageMenuManager;
    private MapStorageAction fDefaultAction;

    public void run(IAction action) {
        ITextEditor editor = this.getEditor();
        if (editor != null && this.fDefaultAction != null) {
            this.fDefaultAction.run();
        }
    }

    @Override
    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        Object debugContextElement;
        super.setActiveEditor(action, targetEditor);
        ITextEditor editor = this.getEditor();
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (editor != null && action != null && debugContext != null && (debugContextElement = debugContext.getAdapter(IDebugTarget.class)) instanceof PICLDebugTarget) {
            this.fStorageMenuManager = new MonitorMemoryMenuManager(editor, (PICLDebugTarget)((Object)debugContextElement));
            action.setMenuCreator((IMenuCreator)new MenuCreator());
            MapStorageAction[] storageActions = this.fStorageMenuManager.getActions();
            if (storageActions.length > 0) {
                this.fDefaultAction = storageActions[0];
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
    }

    private class MenuCreator
    implements IMenuCreator {
        Menu fMenu = null;

        private MenuCreator() {
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu == null) {
                this.fMenu = new Menu(parent);
                this.fillMenu(this.fMenu);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            if (this.fMenu == null) {
                this.fMenu = new Menu(parent);
                this.fillMenu(this.fMenu);
            }
            return this.fMenu;
        }

        private void fillMenu(Menu menu) {
            if (MonitorMemoryEditorActionDelegate.this.fStorageMenuManager != null) {
                int index = 0;
                MapStorageAction[] mapStorageActionArray = MonitorMemoryEditorActionDelegate.this.fStorageMenuManager.getActions();
                int n = mapStorageActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MapStorageAction action = mapStorageActionArray[n2];
                    new ActionContributionItem((IAction)action).fill(menu, index++);
                    ++n2;
                }
            }
        }
    }
}

