/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class MonitorLocalExpressionActionDelegate
implements IObjectActionDelegate,
ISelectionListener {
    private IWorkbenchWindow fWindow;
    private ISelection fCurrentSelection = null;
    private IAction proxyAction = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.proxyAction = action;
        this.fWindow = targetPart.getSite().getWorkbenchWindow();
        this.fWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        ISelection selection = this.fWindow.getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        PDTDebugTarget dbgtgt = PICLDebugPlugin.getPDTDebugTarget(selection);
        if (dbgtgt == null || !dbgtgt.isAcceptingRequests()) {
            this.proxyAction.setEnabled(false);
        } else {
            this.proxyAction.setEnabled(true);
        }
    }

    public void run(IAction action) {
        if (!(this.fCurrentSelection instanceof IStructuredSelection)) {
            return;
        }
        StackFrame stackframe = PICLDebugPlugin.getCurrentStackFrame();
        if (stackframe == null) {
            return;
        }
        final Location location = stackframe.getLocation();
        final DebuggeeThread thread = (DebuggeeThread)stackframe.getThread();
        if (location == null || thread == null || !thread.isSuspended()) {
            return;
        }
        Job monitorJob = new Job("Monitor Local Variable"){

            protected IStatus run(IProgressMonitor monitor) {
                IdentifierParser parser = null;
                try {
                    parser = location.getViewFile().getPart().getLanguage().getIdentifierParser();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                boolean atLeastOneSuccess = false;
                for (ExprNodeBase element : (IStructuredSelection)MonitorLocalExpressionActionDelegate.this.fCurrentSelection) {
                    try {
                        String localVarName = element.getNodeExpression(false);
                        if (parser != null) {
                            localVarName = parser.doLanguageSpecifics(localVarName, localVarName, 0);
                        }
                        thread.monitorExpression(location, localVarName);
                        atLeastOneSuccess = true;
                    }
                    catch (EngineRequestException e) {
                        PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                    }
                }
                if (atLeastOneSuccess) {
                    CommonUtils.asyncShowView((String)"com.ibm.debug.pdt.ui.MonitorView");
                }
                return Status.OK_STATUS;
            }
        };
        monitorJob.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fCurrentSelection = selection;
        this.proxyAction = action;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.proxyAction == null) {
            return;
        }
        PDTDebugTarget dbgtgt = PICLDebugPlugin.getPDTDebugTarget(selection);
        if (dbgtgt == null || !dbgtgt.isAcceptingRequests() || this.fCurrentSelection == null || this.fCurrentSelection.isEmpty()) {
            this.proxyAction.setEnabled(false);
        } else {
            this.proxyAction.setEnabled(true);
        }
    }
}

